/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.inject.Module;
import java.util.Properties;
import org.jclouds.cloudstack.CloudStackAsyncClient;
import org.jclouds.cloudstack.CloudStackClient;
import org.jclouds.cloudstack.config.CloudStackRestClientModule;
import org.jclouds.cloudstack.filters.QuerySigner;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.http.RequiresHttp;
import org.jclouds.rest.ConfiguresRestClient;
import org.jclouds.rest.RestClientTest;
import org.jclouds.rest.RestContextFactory;
import org.jclouds.rest.RestContextSpec;
import org.testng.Assert;

public abstract class BaseCloudStackAsyncClientTest<T>
extends RestClientTest<T> {
    protected void checkFilters(HttpRequest request) {
        Assert.assertEquals((int)request.getFilters().size(), (int)1);
        Assert.assertEquals(((HttpRequestFilter)request.getFilters().get(0)).getClass(), QuerySigner.class);
    }

    protected Module createModule() {
        return new CloudStackRestClientModuleExtension();
    }

    public RestContextSpec<CloudStackClient, CloudStackAsyncClient> createContextSpec() {
        Properties props = new Properties();
        props.setProperty("cloudstack.endpoint", "http://localhost:8080/client/api");
        return new RestContextFactory().createContextSpec("cloudstack", "apiKey", "secretKey", props);
    }

    @RequiresHttp
    @ConfiguresRestClient
    public static class CloudStackRestClientModuleExtension
    extends CloudStackRestClientModule {
    }
}

