/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.compute.strategy;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jclouds.cloudstack.compute.options.CloudStackTemplateOptions;
import org.jclouds.cloudstack.compute.strategy.AdvancedNetworkOptionsConverter;
import org.jclouds.cloudstack.compute.strategy.BasicNetworkOptionsConverter;
import org.jclouds.cloudstack.domain.Network;
import org.jclouds.cloudstack.domain.NetworkService;
import org.jclouds.cloudstack.options.DeployVirtualMachineOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(singleThreaded=true, testName="OptionsConverterTest")
public class OptionsConverterTest {
    private static final Map<Long, Network> EMPTY_NETWORKS_MAP = Collections.emptyMap();
    private static final int ZONE_ID = 2;
    private final NetworkService firewallServiceWithStaticNat = new NetworkService("Firewall", (Map)ImmutableMap.of((Object)"StaticNat", (Object)"true"));

    @Test
    public void testBasicNetworkOptionsConverter() {
        DeployVirtualMachineOptions optionsOut = new DeployVirtualMachineOptions();
        BasicNetworkOptionsConverter converter = new BasicNetworkOptionsConverter();
        CloudStackTemplateOptions optionsIn = CloudStackTemplateOptions.Builder.securityGroupId((long)42L).networkId(46L);
        DeployVirtualMachineOptions optionsOut2 = converter.apply(optionsIn, EMPTY_NETWORKS_MAP, 2L, optionsOut);
        Assert.assertTrue((optionsOut == optionsOut2 ? 1 : 0) != 0);
        DeployVirtualMachineOptions optionsExpected = DeployVirtualMachineOptions.Builder.securityGroupId((long)42L).networkId(46L);
        Assert.assertEquals((Object)optionsOut, (Object)optionsExpected);
    }

    @Test
    public void testAdvancedSecurityGroupsNotAllowed() {
        boolean exceptionThrown = false;
        AdvancedNetworkOptionsConverter converter = new AdvancedNetworkOptionsConverter();
        CloudStackTemplateOptions optionsIn = CloudStackTemplateOptions.Builder.securityGroupId((long)42L);
        try {
            converter.apply(optionsIn, EMPTY_NETWORKS_MAP, 2L, DeployVirtualMachineOptions.NONE);
        }
        catch (IllegalArgumentException e) {
            exceptionThrown = true;
        }
        Assert.assertTrue((boolean)exceptionThrown, (String)"IllegalArgumentException should have been thrown");
    }

    @Test
    public void testAdvancedExplicitNetworkSelection() {
        AdvancedNetworkOptionsConverter converter = new AdvancedNetworkOptionsConverter();
        DeployVirtualMachineOptions optionsActual = converter.apply(CloudStackTemplateOptions.Builder.networkId((long)42L), EMPTY_NETWORKS_MAP, 2L, DeployVirtualMachineOptions.NONE);
        DeployVirtualMachineOptions optionsExpected = DeployVirtualMachineOptions.Builder.networkId((long)42L);
        Assert.assertEquals((Object)optionsActual, (Object)optionsExpected);
    }

    @Test
    public void testAdvancedAutoDetectNetwork() {
        AdvancedNetworkOptionsConverter converter = new AdvancedNetworkOptionsConverter();
        Network eligibleNetwork = Network.builder().id(25L).zoneId(2L).isDefault(true).services((Set)ImmutableSet.of((Object)this.firewallServiceWithStaticNat)).build();
        DeployVirtualMachineOptions optionsActual = converter.apply(CloudStackTemplateOptions.NONE, (Map)ImmutableMap.of((Object)eligibleNetwork.getId(), (Object)eligibleNetwork), 2L, DeployVirtualMachineOptions.NONE);
        DeployVirtualMachineOptions optionsExpected = DeployVirtualMachineOptions.Builder.networkId((long)25L);
        Assert.assertEquals((Object)optionsActual, (Object)optionsExpected);
    }

    @Test
    public void testAdvancedWhenNoNetworkGiven() {
        AdvancedNetworkOptionsConverter converter = new AdvancedNetworkOptionsConverter();
        boolean exceptionThrown = false;
        try {
            converter.apply(CloudStackTemplateOptions.NONE, EMPTY_NETWORKS_MAP, 2L, DeployVirtualMachineOptions.NONE);
        }
        catch (IllegalArgumentException e) {
            exceptionThrown = true;
        }
        Assert.assertTrue((boolean)exceptionThrown);
    }

    @Test
    public void testAdvancedWhenNoNetworkEligible() {
        AdvancedNetworkOptionsConverter converter = new AdvancedNetworkOptionsConverter();
        Network unsuitableNetwork = Network.builder().id(25L).zoneId(2L).build();
        boolean exceptionThrown = false;
        try {
            converter.apply(CloudStackTemplateOptions.NONE, (Map)ImmutableMap.of((Object)unsuitableNetwork.getId(), (Object)unsuitableNetwork), 2L, DeployVirtualMachineOptions.NONE);
        }
        catch (IllegalArgumentException e) {
            exceptionThrown = true;
        }
        Assert.assertTrue((boolean)exceptionThrown);
    }
}

