/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.compute;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.net.URI;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jclouds.cloudstack.CloudStackClient;
import org.jclouds.cloudstack.CloudStackDomainClient;
import org.jclouds.cloudstack.compute.options.CloudStackTemplateOptions;
import org.jclouds.cloudstack.domain.Network;
import org.jclouds.cloudstack.domain.NetworkOffering;
import org.jclouds.cloudstack.domain.TrafficType;
import org.jclouds.cloudstack.features.BaseCloudStackClientLiveTest;
import org.jclouds.cloudstack.options.CreateNetworkOptions;
import org.jclouds.cloudstack.options.ListNetworkOfferingsOptions;
import org.jclouds.cloudstack.options.ListNetworksOptions;
import org.jclouds.compute.RunNodesException;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.predicates.NodePredicates;
import org.testng.annotations.Test;

@Test(groups={"live"}, testName="CloudStackExperimentLiveTest")
public class CloudStackExperimentLiveTest
extends BaseCloudStackClientLiveTest {
    public CloudStackExperimentLiveTest() {
        this.provider = "cloudstack";
    }

    protected void deleteNetworksInZoneWithVlanId(long zoneId, String vlanId) {
        Set networks = ((CloudStackDomainClient)this.domainAdminContext.getApi()).getNetworkClient().listNetworks(new ListNetworksOptions[]{ListNetworksOptions.Builder.isDefault((boolean)false).isSystem(false).zoneId(zoneId).trafficType(TrafficType.GUEST)});
        URI broadcastUri = URI.create("vlan://" + vlanId);
        for (Network net : networks) {
            if (!broadcastUri.equals(net.getBroadcastURI())) continue;
            long jobId = ((CloudStackDomainClient)this.domainAdminContext.getApi()).getNetworkClient().deleteNetwork(net.getId());
            this.adminJobComplete.apply((Object)jobId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAndExperiment() {
        if (!this.domainAdminEnabled) {
            Logger.getAnonymousLogger().log(Level.SEVERE, "domainAdmin credentials not present, skipping test");
            return;
        }
        String group = this.prefix + "-vlan";
        String vlanId = "2";
        Network network = null;
        Set nodes = null;
        try {
            assert (this.computeContext.getComputeService().listAssignableLocations().size() > 0);
            Template template = this.computeContext.getComputeService().templateBuilder().build();
            long zoneId = Long.parseLong(template.getLocation().getId());
            this.deleteNetworksInZoneWithVlanId(zoneId, vlanId);
            long offeringId = ((NetworkOffering)Iterables.get((Iterable)((CloudStackClient)this.context.getApi()).getOfferingClient().listNetworkOfferings(new ListNetworkOfferingsOptions[]{ListNetworkOfferingsOptions.Builder.specifyVLAN((boolean)true).zoneId(zoneId)}), (int)0)).getId();
            network = ((CloudStackDomainClient)this.domainAdminContext.getApi()).getNetworkClient().createNetworkInZone(zoneId, offeringId, group, group, new CreateNetworkOptions[]{CreateNetworkOptions.Builder.vlan((String)vlanId).startIP("192.168.1.2").netmask("255.255.255.0").gateway("192.168.1.1")});
            ((CloudStackTemplateOptions)template.getOptions().as(CloudStackTemplateOptions.class)).networkId(network.getId());
            nodes = this.computeContext.getComputeService().createNodesInGroup(group, 1, template);
            assert (nodes.size() > 0);
        }
        catch (RunNodesException e) {
            Logger.getAnonymousLogger().log(Level.SEVERE, "error creating nodes", e);
            nodes = Sets.newTreeSet((Iterable)Iterables.concat((Iterable)e.getSuccessfulNodes(), e.getNodeErrors().keySet()));
        }
        finally {
            if (nodes != null) {
                this.computeContext.getComputeService().destroyNodesMatching(NodePredicates.inGroup((String)group));
            }
            if (network != null) {
                ((CloudStackDomainClient)this.domainAdminContext.getApi()).getNetworkClient().deleteNetwork(network.getId());
            }
        }
    }
}

