/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.compute;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.net.InetAddresses;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import com.google.inject.name.Names;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.inject.Singleton;
import org.jclouds.cloudstack.CloudStackClient;
import org.jclouds.cloudstack.compute.config.CloudStackComputeServiceContextModule;
import org.jclouds.cloudstack.compute.options.CloudStackTemplateOptions;
import org.jclouds.cloudstack.compute.strategy.CloudStackComputeServiceAdapter;
import org.jclouds.cloudstack.domain.IPForwardingRule;
import org.jclouds.cloudstack.domain.Network;
import org.jclouds.cloudstack.domain.ServiceOffering;
import org.jclouds.cloudstack.domain.Template;
import org.jclouds.cloudstack.domain.User;
import org.jclouds.cloudstack.domain.VirtualMachine;
import org.jclouds.cloudstack.features.BaseCloudStackClientLiveTest;
import org.jclouds.cloudstack.functions.StaticNATVirtualMachineInNetwork;
import org.jclouds.cloudstack.predicates.JobComplete;
import org.jclouds.cloudstack.predicates.TemplatePredicates;
import org.jclouds.cloudstack.suppliers.GetCurrentUser;
import org.jclouds.cloudstack.suppliers.NetworksForCurrentUser;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.ComputeTestUtils;
import org.jclouds.compute.functions.DefaultCredentialsFromImageOrOverridingCredentials;
import org.jclouds.compute.strategy.PrioritizeCredentialsFromTemplate;
import org.jclouds.domain.Credentials;
import org.jclouds.logging.log4j.config.Log4JLoggingModule;
import org.jclouds.net.IPSocket;
import org.jclouds.predicates.RetryablePredicate;
import org.jclouds.rest.annotations.Identity;
import org.testng.Assert;
import org.testng.annotations.AfterGroups;
import org.testng.annotations.BeforeGroups;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="CloudStackComputeServiceAdapterLiveTest")
public class CloudStackComputeServiceAdapterLiveTest
extends BaseCloudStackClientLiveTest {
    private CloudStackComputeServiceAdapter adapter;
    private ComputeServiceAdapter.NodeAndInitialCredentials<VirtualMachine> vm;
    private String keyPairName;
    private Map<String, String> keyPair;
    Map<String, Credentials> credentialStore = Maps.newLinkedHashMap();
    private static final PrioritizeCredentialsFromTemplate prioritizeCredentialsFromTemplate = new PrioritizeCredentialsFromTemplate((Function)new DefaultCredentialsFromImageOrOverridingCredentials());

    @Override
    @BeforeGroups(groups={"live"})
    public void setupClient() {
        super.setupClient();
        AbstractModule module = new AbstractModule(){

            protected void configure() {
                Names.bindProperties((Binder)this.binder(), (Properties)CloudStackComputeServiceAdapterLiveTest.this.setupProperties());
                this.bind(String.class).annotatedWith(Identity.class).toInstance((Object)CloudStackComputeServiceAdapterLiveTest.this.identity);
                this.bind((TypeLiteral)new TypeLiteral<Supplier<User>>(){}).annotatedWith(Memoized.class).to(GetCurrentUser.class).in(Scopes.SINGLETON);
                this.bind((TypeLiteral)new TypeLiteral<Supplier<Map<Long, Network>>>(){}).annotatedWith(Memoized.class).to(NetworksForCurrentUser.class).in(Scopes.SINGLETON);
                this.bind((TypeLiteral)new TypeLiteral<Map<String, Credentials>>(){}).toInstance(CloudStackComputeServiceAdapterLiveTest.this.credentialStore);
                this.bind(CloudStackClient.class).toInstance(CloudStackComputeServiceAdapterLiveTest.this.context.getApi());
                this.install(new FactoryModuleBuilder().build(StaticNATVirtualMachineInNetwork.Factory.class));
            }

            @Provides
            @Singleton
            protected Predicate<Long> jobComplete(JobComplete jobComplete) {
                return new RetryablePredicate((Predicate)jobComplete, 1200L, 1L, 5L, TimeUnit.SECONDS);
            }

            @Provides
            @Singleton
            protected LoadingCache<Long, Set<IPForwardingRule>> getIPForwardingRuleByVirtualMachine(CloudStackComputeServiceContextModule.GetIPForwardingRulesByVirtualMachine getIPForwardingRule) {
                return CacheBuilder.newBuilder().build((CacheLoader)getIPForwardingRule);
            }
        };
        this.adapter = (CloudStackComputeServiceAdapter)Guice.createInjector((Module[])new Module[]{module, new Log4JLoggingModule()}).getInstance(CloudStackComputeServiceAdapter.class);
        this.keyPairName = this.prefix + "-adapter-test-keypair";
        try {
            this.keyPair = ComputeTestUtils.setupKeyPair();
        }
        catch (IOException e) {
            Assert.fail((String)"Unable to create keypair", (Throwable)e);
        }
    }

    @Test
    public void testListLocations() {
        Assert.assertFalse((boolean)Iterables.isEmpty((Iterable)this.adapter.listLocations()));
    }

    @Test
    public void testCreateNodeWithGroupEncodedIntoName() throws InterruptedException {
        String group = this.prefix + "-foo";
        String name = group + "-node-" + new Random().nextInt();
        org.jclouds.compute.domain.Template template = this.computeContext.getComputeService().templateBuilder().build();
        if (!this.client.getTemplateClient().getTemplateInZone(Long.parseLong(template.getImage().getId()), Long.parseLong(template.getLocation().getId())).isPasswordEnabled()) {
            ((CloudStackTemplateOptions)template.getOptions().as(CloudStackTemplateOptions.class)).keyPair(this.keyPairName);
        }
        this.vm = this.adapter.createNodeWithGroupEncodedIntoName(group, name, template);
        Assert.assertEquals((String)((VirtualMachine)this.vm.getNode()).getDisplayName(), (String)name);
        IPForwardingRule rule = (IPForwardingRule)Iterables.getFirst((Iterable)this.client.getNATClient().getIPForwardingRulesForVirtualMachine(((VirtualMachine)this.vm.getNode()).getId()), null);
        String address = rule != null ? rule.getIPAddress() : ((VirtualMachine)this.vm.getNode()).getIPAddress();
        this.loginCredentials = prioritizeCredentialsFromTemplate.apply(template, this.vm.getCredentials());
        assert (InetAddresses.isInetAddress((String)address)) : this.vm;
        IPSocket socket = new IPSocket(address, 22);
        this.checkSSH(socket);
    }

    @Test
    public void testListHardwareProfiles() {
        Iterable profiles = this.adapter.listHardwareProfiles();
        Assert.assertFalse((boolean)Iterables.isEmpty((Iterable)profiles));
        for (ServiceOffering serviceOffering : profiles) {
        }
    }

    @Test
    public void testListImages() {
        Iterable templates = this.adapter.listImages();
        Assert.assertFalse((boolean)Iterables.isEmpty((Iterable)templates));
        for (Template template : templates) {
            assert (TemplatePredicates.isReady().apply((Object)template)) : template;
        }
    }

    @Override
    @AfterGroups(groups={"live"})
    protected void tearDown() {
        if (this.vm != null) {
            this.adapter.destroyNode(this.vm.getNodeId());
        }
        super.tearDown();
    }
}

