/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudsigma.functions;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.jclouds.cloudsigma.domain.ProfileInfo;
import org.jclouds.cloudsigma.domain.ProfileType;
import org.jclouds.cloudsigma.functions.ListOfKeyValuesDelimitedByBlankLinesToListOfMaps;
import org.jclouds.cloudsigma.functions.MapToProfileInfo;
import org.jclouds.util.Strings2;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class MapToProfileInfoTest {
    public static ProfileInfo ONE = new ProfileInfo.Builder().type(ProfileType.REGULAR).uuid("58ca3c1f-7629-4771-9b71-863f40153ba4").email("adrian@jclouds.org").firstName("Adrian").lastName("Cole").nickName("jclouds").build();
    private static final MapToProfileInfo MAP_TO_PROFILE = new MapToProfileInfo();

    public void testEmptyMapReturnsNull() {
        Assert.assertEquals((Object)MAP_TO_PROFILE.apply((Map)ImmutableMap.of()), null);
    }

    public void test() throws IOException {
        Map input = (Map)new ListOfKeyValuesDelimitedByBlankLinesToListOfMaps().apply(Strings2.toStringAndClose((InputStream)MapToProfileInfoTest.class.getResourceAsStream("/profile.txt"))).get(0);
        Assert.assertEquals((Object)MAP_TO_PROFILE.apply(input), (Object)ONE);
    }
}

