/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudsigma.functions;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jclouds.cloudsigma.domain.Device;
import org.jclouds.cloudsigma.domain.DriveMetrics;
import org.jclouds.cloudsigma.domain.NIC;
import org.jclouds.cloudsigma.domain.ServerMetrics;
import org.jclouds.cloudsigma.functions.ListOfKeyValuesDelimitedByBlankLinesToServerInfoSet;
import org.jclouds.cloudsigma.functions.MapToDevices;
import org.jclouds.cloudsigma.functions.MapToDriveMetrics;
import org.jclouds.cloudsigma.functions.MapToNICs;
import org.jclouds.cloudsigma.functions.MapToServerInfoTest;
import org.jclouds.cloudsigma.functions.MapToServerMetrics;
import org.jclouds.http.HttpResponse;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class ListOfKeyValuesDelimitedByBlankLinesToServerInfoSetTest {
    private static final ListOfKeyValuesDelimitedByBlankLinesToServerInfoSet FN = (ListOfKeyValuesDelimitedByBlankLinesToServerInfoSet)Guice.createInjector((Module[])new Module[]{new AbstractModule(){

        protected void configure() {
            this.bind((TypeLiteral)new TypeLiteral<Function<Map<String, String>, List<NIC>>>(){}).to(MapToNICs.class);
            this.bind((TypeLiteral)new TypeLiteral<Function<Map<String, String>, Map<String, ? extends Device>>>(){}).to(MapToDevices.class);
            this.bind((TypeLiteral)new TypeLiteral<Function<Map<String, String>, Map<String, ? extends DriveMetrics>>>(){}).to(MapToDriveMetrics.class);
            this.bind((TypeLiteral)new TypeLiteral<Function<Map<String, String>, ServerMetrics>>(){}).to(MapToServerMetrics.class);
            this.bind((TypeLiteral)new TypeLiteral<Function<Device, String>>(){}).to(MapToDevices.DeviceToId.class);
        }
    }}).getInstance(ListOfKeyValuesDelimitedByBlankLinesToServerInfoSet.class);

    public void testNone() {
        Assert.assertEquals((Set)FN.apply(new HttpResponse(200, "", (Payload)Payloads.newStringPayload((String)""))), (Set)ImmutableSet.of());
        Assert.assertEquals((Set)FN.apply(new HttpResponse(200, "", (Payload)Payloads.newStringPayload((String)"\n\n"))), (Set)ImmutableSet.of());
        Assert.assertEquals((Set)FN.apply(new HttpResponse(200, "", null)), (Set)ImmutableSet.of());
    }

    public void testOne() {
        Assert.assertEquals((Set)FN.apply(new HttpResponse(200, "", (Payload)Payloads.newInputStreamPayload((InputStream)MapToServerInfoTest.class.getResourceAsStream("/servers.txt")))), (Set)ImmutableSet.of((Object)MapToServerInfoTest.ONE, (Object)MapToServerInfoTest.TWO));
    }
}

