/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudsigma.functions;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.Collection;
import org.jclouds.cloudsigma.functions.ListOfKeyValuesDelimitedByBlankLinesToListOfMaps;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class ListOfKeyValuesDelimitedByBlankLinesToListOfMapsTest {
    private static final ListOfKeyValuesDelimitedByBlankLinesToListOfMaps FN = new ListOfKeyValuesDelimitedByBlankLinesToListOfMaps();

    public void testNone() {
        Assert.assertEquals((Collection)FN.apply(""), (Collection)Lists.newArrayList());
        Assert.assertEquals((Collection)FN.apply("\n\n\n"), (Collection)Lists.newArrayList());
    }

    public void testOneMap() {
        Assert.assertEquals((Collection)FN.apply("key1 value1\nkey2 value2"), (Collection)ImmutableList.of((Object)ImmutableMap.of((Object)"key1", (Object)"value1", (Object)"key2", (Object)"value2")));
        Assert.assertEquals((Collection)FN.apply("key1 value1\nkey2 value2\n\n"), (Collection)ImmutableList.of((Object)ImmutableMap.of((Object)"key1", (Object)"value1", (Object)"key2", (Object)"value2")));
    }

    public void testValueEncodesNewlines() {
        Assert.assertEquals((Collection)FN.apply("key1 value1\\n\nkey2 value2"), (Collection)ImmutableList.of((Object)ImmutableMap.of((Object)"key1", (Object)"value1\n", (Object)"key2", (Object)"value2")));
    }

    public void testTwoMaps() {
        Assert.assertEquals((Collection)FN.apply("key1 value1\nkey2 value2\n\nkey1 v1\nkey2 v2"), (Collection)ImmutableList.of((Object)ImmutableMap.of((Object)"key1", (Object)"value1", (Object)"key2", (Object)"value2"), (Object)ImmutableMap.of((Object)"key1", (Object)"v1", (Object)"key2", (Object)"v2")));
        Assert.assertEquals((Collection)FN.apply("key1 value1\nkey2 value2\n\nkey1 v1\nkey2 v2\n\n"), (Collection)ImmutableList.of((Object)ImmutableMap.of((Object)"key1", (Object)"value1", (Object)"key2", (Object)"value2"), (Object)ImmutableMap.of((Object)"key1", (Object)"v1", (Object)"key2", (Object)"v2")));
    }
}

