/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudsigma.binders;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Guice;
import com.google.inject.Module;
import java.io.IOException;
import java.util.List;
import org.easymock.classextension.EasyMock;
import org.jclouds.cloudsigma.binders.BindCloneDriveOptionsToPlainTextString;
import org.jclouds.cloudsigma.options.CloneDriveOptions;
import org.jclouds.http.HttpRequest;
import org.jclouds.io.MutableContentMetadata;
import org.jclouds.io.Payload;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class BindCloneDriveOptionsToPlainTextStringTest {
    private static final BindCloneDriveOptionsToPlainTextString binder = (BindCloneDriveOptionsToPlainTextString)Guice.createInjector((Module[])new Module[0]).getInstance(BindCloneDriveOptionsToPlainTextString.class);

    public void testDefault() throws IOException {
        this.assertInputAndArgsCreatesPayload((ImmutableMap<String, String>)ImmutableMap.of((Object)"name", (Object)"newdrive"), (List<Object>)ImmutableList.of(), "name newdrive");
    }

    public void testWithSize() throws IOException {
        this.assertInputAndArgsCreatesPayload((ImmutableMap<String, String>)ImmutableMap.of((Object)"name", (Object)"newdrive"), (List<Object>)ImmutableList.of((Object)new CloneDriveOptions().size(1024L)), "name newdrive\nsize 1024");
    }

    protected void assertInputAndArgsCreatesPayload(ImmutableMap<String, String> inputMap, List<Object> args, String expected) {
        GeneratedHttpRequest request = (GeneratedHttpRequest)EasyMock.createMock(GeneratedHttpRequest.class);
        org.easymock.EasyMock.expect((Object)request.getArgs()).andReturn(args).atLeastOnce();
        request.setPayload(expected);
        Payload payload = (Payload)EasyMock.createMock(Payload.class);
        org.easymock.EasyMock.expect((Object)request.getPayload()).andReturn((Object)payload);
        MutableContentMetadata md = (MutableContentMetadata)EasyMock.createMock(MutableContentMetadata.class);
        org.easymock.EasyMock.expect((Object)payload.getContentMetadata()).andReturn((Object)md);
        md.setContentType("text/plain");
        EasyMock.replay((Object[])new Object[]{request});
        EasyMock.replay((Object[])new Object[]{payload});
        EasyMock.replay((Object[])new Object[]{md});
        binder.bindToRequest((HttpRequest)request, inputMap);
        EasyMock.verify((Object[])new Object[]{request});
        EasyMock.verify((Object[])new Object[]{payload});
        EasyMock.verify((Object[])new Object[]{md});
    }
}

