/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudsigma.predicates;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.cloudsigma.CloudSigmaClient;
import org.jclouds.cloudsigma.domain.DriveInfo;
import org.jclouds.logging.Logger;

@Singleton
public class DriveClaimed
implements Predicate<DriveInfo> {
    private final CloudSigmaClient client;
    @Resource
    protected Logger logger = Logger.NULL;

    @Inject
    public DriveClaimed(CloudSigmaClient client) {
        this.client = client;
    }

    public boolean apply(DriveInfo drive) {
        this.logger.trace("looking for claims on drive %s", new Object[]{Preconditions.checkNotNull((Object)drive, (Object)"drive")});
        drive = this.refresh(drive);
        if (drive == null) {
            return false;
        }
        this.logger.trace("%s: looking for drive claims: currently: %s", new Object[]{drive.getUuid(), drive.getClaimed()});
        return drive.getClaimed().size() > 0;
    }

    private DriveInfo refresh(DriveInfo drive) {
        return this.client.getDriveInfo(drive.getUuid());
    }
}

