/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudsigma.functions;

import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.inject.Singleton;
import org.jclouds.cloudsigma.domain.ClaimType;
import org.jclouds.cloudsigma.domain.DriveInfo;
import org.jclouds.cloudsigma.domain.DriveMetrics;
import org.jclouds.cloudsigma.domain.DriveStatus;
import org.jclouds.cloudsigma.domain.DriveType;
import org.jclouds.logging.Logger;

@Singleton
public class MapToDriveInfo
implements Function<Map<String, String>, DriveInfo> {
    @Resource
    protected Logger logger = Logger.NULL;

    public DriveInfo apply(Map<String, String> from) {
        if (from.size() == 0) {
            return null;
        }
        DriveInfo.Builder builder = new DriveInfo.Builder();
        builder.name(from.get("name"));
        if (from.containsKey("use")) {
            builder.use(Splitter.on((char)' ').split((CharSequence)from.get("use")));
        }
        if (from.containsKey("status")) {
            builder.status(DriveStatus.fromValue(from.get("status")));
        }
        builder.metrics(this.buildMetrics(from));
        builder.user(from.get("user"));
        builder.encryptionCipher(from.get("encryption:cipher"));
        builder.uuid(from.get("drive"));
        if (from.containsKey("claim:type")) {
            builder.claimType(ClaimType.fromValue(from.get("claim:type")));
        }
        if (from.containsKey("claimed")) {
            builder.claimed(Splitter.on((char)' ').split((CharSequence)from.get("claimed")));
        }
        if (from.containsKey("tags")) {
            builder.tags(Splitter.on((char)' ').split((CharSequence)from.get("tags")));
        }
        if (from.containsKey("readers")) {
            builder.readers(Splitter.on((char)' ').split((CharSequence)from.get("readers")));
        }
        if (from.containsKey("size")) {
            builder.size(new Long(from.get("size")));
        }
        LinkedHashMap metadata = Maps.newLinkedHashMap();
        for (Map.Entry<String, String> entry : from.entrySet()) {
            if (!entry.getKey().startsWith("user:")) continue;
            metadata.put(entry.getKey().substring(entry.getKey().indexOf(58) + 1), entry.getValue());
        }
        if (from.containsKey("use")) {
            builder.use(Splitter.on((char)' ').split((CharSequence)from.get("use")));
        }
        if (from.containsKey("bits")) {
            builder.bits(new Integer(from.get("bits")));
        }
        if (from.containsKey("url")) {
            builder.url(URI.create(from.get("url")));
        }
        builder.encryptionKey(from.get("encryption:key"));
        builder.description(from.get("description"));
        builder.installNotes(from.get("install_notes"));
        builder.os(from.get("os"));
        if (from.containsKey("drive_type")) {
            builder.driveType(Splitter.on((char)',').split((CharSequence)from.get("drive_type")));
        }
        if (from.containsKey("autoexpanding")) {
            builder.autoexpanding(new Boolean(from.get("autoexpanding")));
        }
        if (from.containsKey("free")) {
            builder.free(new Boolean(from.get("free")));
        }
        if (from.containsKey("type")) {
            builder.type(DriveType.fromValue(from.get("type")));
        }
        try {
            return builder.build();
        }
        catch (NullPointerException e) {
            this.logger.trace("entry missing data: %s; %s", new Object[]{e.getMessage(), from});
            return null;
        }
    }

    protected DriveMetrics buildMetrics(Map<String, String> from) {
        DriveMetrics.Builder metricsBuilder = new DriveMetrics.Builder();
        if (from.containsKey("read:bytes")) {
            metricsBuilder.readBytes(new Long(from.get("read:bytes")));
        }
        if (from.containsKey("read:requests")) {
            metricsBuilder.readRequests(new Long(from.get("read:requests")));
        }
        if (from.containsKey("write:bytes")) {
            metricsBuilder.writeBytes(new Long(from.get("write:bytes")));
        }
        if (from.containsKey("write:requests")) {
            metricsBuilder.writeRequests(new Long(from.get("write:requests")));
        }
        return metricsBuilder.build();
    }
}

