/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudsigma.config;

import com.google.common.base.Function;
import com.google.inject.TypeLiteral;
import java.util.List;
import java.util.Map;
import org.jclouds.cloudsigma.CloudSigmaAsyncClient;
import org.jclouds.cloudsigma.CloudSigmaClient;
import org.jclouds.cloudsigma.domain.Device;
import org.jclouds.cloudsigma.domain.Drive;
import org.jclouds.cloudsigma.domain.DriveData;
import org.jclouds.cloudsigma.domain.DriveMetrics;
import org.jclouds.cloudsigma.domain.NIC;
import org.jclouds.cloudsigma.domain.Server;
import org.jclouds.cloudsigma.domain.ServerMetrics;
import org.jclouds.cloudsigma.functions.BaseDriveToMap;
import org.jclouds.cloudsigma.functions.DriveDataToMap;
import org.jclouds.cloudsigma.functions.MapToDevices;
import org.jclouds.cloudsigma.functions.MapToDriveMetrics;
import org.jclouds.cloudsigma.functions.MapToNICs;
import org.jclouds.cloudsigma.functions.MapToServerMetrics;
import org.jclouds.cloudsigma.functions.ServerToMap;
import org.jclouds.cloudsigma.handlers.CloudSigmaErrorHandler;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.RequiresHttp;
import org.jclouds.http.annotation.ClientError;
import org.jclouds.http.annotation.Redirection;
import org.jclouds.http.annotation.ServerError;
import org.jclouds.rest.ConfiguresRestClient;
import org.jclouds.rest.config.RestClientModule;

@RequiresHttp
@ConfiguresRestClient
public class CloudSigmaRestClientModule
extends RestClientModule<CloudSigmaClient, CloudSigmaAsyncClient> {
    public CloudSigmaRestClientModule() {
        super(CloudSigmaClient.class, CloudSigmaAsyncClient.class);
    }

    protected void bindErrorHandlers() {
        this.bind(HttpErrorHandler.class).annotatedWith(Redirection.class).to(CloudSigmaErrorHandler.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ClientError.class).to(CloudSigmaErrorHandler.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ServerError.class).to(CloudSigmaErrorHandler.class);
    }

    protected void configure() {
        super.configure();
        this.bind((TypeLiteral)new TypeLiteral<Function<Drive, Map<String, String>>>(){}).to(BaseDriveToMap.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<DriveData, Map<String, String>>>(){}).to(DriveDataToMap.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<Map<String, String>, List<NIC>>>(){}).to(MapToNICs.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<Map<String, String>, Map<String, ? extends Device>>>(){}).to(MapToDevices.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<Map<String, String>, Map<String, ? extends DriveMetrics>>>(){}).to(MapToDriveMetrics.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<Map<String, String>, ServerMetrics>>(){}).to(MapToServerMetrics.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<Device, String>>(){}).to(MapToDevices.DeviceToId.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<Server, Map<String, String>>>(){}).to(ServerToMap.class);
    }

    protected void bindRetryHandlers() {
    }
}

