/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudsigma;

import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jclouds.cloudsigma.domain.Drive;
import org.jclouds.cloudsigma.domain.DriveData;
import org.jclouds.cloudsigma.domain.DriveInfo;
import org.jclouds.cloudsigma.domain.ProfileInfo;
import org.jclouds.cloudsigma.domain.Server;
import org.jclouds.cloudsigma.domain.ServerInfo;
import org.jclouds.cloudsigma.domain.StaticIPInfo;
import org.jclouds.cloudsigma.domain.VLANInfo;
import org.jclouds.cloudsigma.options.CloneDriveOptions;
import org.jclouds.concurrent.Timeout;

@Timeout(duration=60L, timeUnit=TimeUnit.SECONDS)
public interface CloudSigmaClient {
    public ProfileInfo getProfileInfo();

    public Set<String> listServers();

    public Set<? extends ServerInfo> listServerInfo();

    public ServerInfo getServerInfo(String var1);

    public ServerInfo createServer(Server var1);

    public ServerInfo setServerConfiguration(String var1, Server var2);

    public void destroyServer(String var1);

    public void startServer(String var1);

    public void stopServer(String var1);

    public void shutdownServer(String var1);

    public void resetServer(String var1);

    public Set<String> listDrives();

    public Set<? extends DriveInfo> listDriveInfo();

    public DriveInfo getDriveInfo(String var1);

    public DriveInfo createDrive(Drive var1);

    public DriveInfo setDriveData(String var1, DriveData var2);

    public void destroyDrive(String var1);

    public Set<String> listStandardDrives();

    public Set<String> listStandardCds();

    public Set<String> listStandardImages();

    @Timeout(duration=300L, timeUnit=TimeUnit.SECONDS)
    public DriveInfo cloneDrive(String var1, String var2, CloneDriveOptions ... var3);

    public Set<String> listVLANs();

    public Set<? extends VLANInfo> listVLANInfo();

    public VLANInfo getVLANInfo(String var1);

    public VLANInfo createVLAN(String var1);

    public VLANInfo renameVLAN(String var1, String var2);

    public void destroyVLAN(String var1);

    public Set<String> listStaticIPs();

    public Set<? extends StaticIPInfo> listStaticIPInfo();

    public StaticIPInfo getStaticIPInfo(String var1);

    public StaticIPInfo createStaticIP();

    public void destroyStaticIP(String var1);
}

