/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudsigma.functions;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.jclouds.cloudsigma.domain.VLANInfo;
import org.jclouds.cloudsigma.functions.ListOfKeyValuesDelimitedByBlankLinesToListOfMaps;
import org.jclouds.cloudsigma.functions.MapToVLANInfo;
import org.jclouds.util.Strings2;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class MapToVLANInfoTest {
    public static VLANInfo ONE = new VLANInfo.Builder().uuid("6e2d1f6a-03c8-422b-bc8e-d744612cf46a").name("My VLAN1").user("f2e19d5c-eaa1-44e5-94aa-dc194594bd7b").build();
    private static final MapToVLANInfo MAP_TO_VLAN = new MapToVLANInfo();

    public void testEmptyMapReturnsNull() {
        Assert.assertEquals((Object)MAP_TO_VLAN.apply((Map)ImmutableMap.of()), null);
    }

    public void test() throws IOException {
        Map input = (Map)new ListOfKeyValuesDelimitedByBlankLinesToListOfMaps().apply(Strings2.toStringAndClose((InputStream)MapToVLANInfoTest.class.getResourceAsStream("/vlan.txt"))).get(0);
        Assert.assertEquals((Object)MAP_TO_VLAN.apply(input), (Object)ONE);
    }
}

