/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudsigma.binders;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import org.jclouds.cloudsigma.binders.BindDriveToPlainTextString;
import org.jclouds.cloudsigma.domain.ClaimType;
import org.jclouds.cloudsigma.domain.CreateDriveRequest;
import org.jclouds.cloudsigma.domain.Drive;
import org.jclouds.cloudsigma.domain.DriveData;
import org.jclouds.cloudsigma.functions.BaseDriveToMap;
import org.jclouds.cloudsigma.functions.DriveDataToMap;
import org.jclouds.http.HttpRequest;
import org.jclouds.util.Strings2;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class BindDriveToPlainTextStringTest {
    private static final BindDriveToPlainTextString FN = (BindDriveToPlainTextString)Guice.createInjector((Module[])new Module[]{new AbstractModule(){

        protected void configure() {
            this.bind((TypeLiteral)new TypeLiteral<Function<Drive, Map<String, String>>>(){}).to(BaseDriveToMap.class);
            this.bind((TypeLiteral)new TypeLiteral<Function<DriveData, Map<String, String>>>(){}).to(DriveDataToMap.class);
        }
    }}).getInstance(BindDriveToPlainTextString.class);

    public void testSimple() {
        HttpRequest request = new HttpRequest("POST", URI.create("https://host/drives/create"));
        FN.bindToRequest(request, (Object)new CreateDriveRequest.Builder().name("foo").size(100L).build());
        Assert.assertEquals((String)request.getPayload().getContentMetadata().getContentType(), (String)"text/plain");
        Assert.assertEquals((Object)request.getPayload().getRawContent(), (Object)"name foo\nsize 100");
    }

    public void testComplete() throws IOException {
        CreateDriveRequest input = new CreateDriveRequest.Builder().name("Ubuntu 10.10 Server Edition Linux 64bit Preinstalled System").size(0x200000000L).claimType(ClaimType.SHARED).readers((Iterable)ImmutableSet.of((Object)"ffffffff-ffff-ffff-ffff-ffffffffffff")).use((Iterable)ImmutableSet.of((Object)"tag1", (Object)"tag2")).encryptionCipher("aes-xts-plain").avoid((Iterable)ImmutableSet.of((Object)"avoid1")).build();
        HttpRequest request = new HttpRequest("POST", URI.create("https://host/drives/create"));
        FN.bindToRequest(request, (Object)input);
        Assert.assertEquals((String)request.getPayload().getContentMetadata().getContentType(), (String)"text/plain");
        Assert.assertEquals((Object)request.getPayload().getRawContent(), (Object)Strings2.toStringAndClose((InputStream)BindDriveToPlainTextStringTest.class.getResourceAsStream("/create_drive.txt")));
    }
}

