/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudsigma;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import com.google.inject.Guice;
import com.google.inject.Module;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.jclouds.cloudsigma.CloudSigmaAsyncClient;
import org.jclouds.cloudsigma.CloudSigmaClient;
import org.jclouds.cloudsigma.domain.ClaimType;
import org.jclouds.cloudsigma.domain.CreateDriveRequest;
import org.jclouds.cloudsigma.domain.Drive;
import org.jclouds.cloudsigma.domain.DriveData;
import org.jclouds.cloudsigma.domain.DriveInfo;
import org.jclouds.cloudsigma.domain.DriveStatus;
import org.jclouds.cloudsigma.domain.DriveType;
import org.jclouds.cloudsigma.domain.IDEDevice;
import org.jclouds.cloudsigma.domain.Model;
import org.jclouds.cloudsigma.domain.NIC;
import org.jclouds.cloudsigma.domain.ProfileInfo;
import org.jclouds.cloudsigma.domain.Server;
import org.jclouds.cloudsigma.domain.ServerInfo;
import org.jclouds.cloudsigma.domain.ServerStatus;
import org.jclouds.cloudsigma.domain.StaticIPInfo;
import org.jclouds.cloudsigma.domain.VLANInfo;
import org.jclouds.cloudsigma.options.CloneDriveOptions;
import org.jclouds.cloudsigma.predicates.DriveClaimed;
import org.jclouds.cloudsigma.util.Servers;
import org.jclouds.compute.BaseVersionedServiceLiveTest;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.ComputeServiceContextFactory;
import org.jclouds.compute.domain.ExecResponse;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.logging.log4j.config.Log4JLoggingModule;
import org.jclouds.net.IPSocket;
import org.jclouds.predicates.InetSocketAddressConnect;
import org.jclouds.predicates.RetryablePredicate;
import org.jclouds.rest.RestContext;
import org.jclouds.ssh.SshClient;
import org.jclouds.sshj.config.SshjSshClientModule;
import org.testng.Assert;
import org.testng.annotations.AfterGroups;
import org.testng.annotations.BeforeGroups;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="CloudSigmaClientLiveTest")
public class CloudSigmaClientLiveTest
extends BaseVersionedServiceLiveTest {
    protected long driveSize = 0x200000000L;
    protected int maxDriveImageTime = 300;
    protected String vncPassword = "Il0veVNC";
    protected CloudSigmaClient client;
    protected RestContext<CloudSigmaClient, CloudSigmaAsyncClient> context;
    protected Predicate<IPSocket> socketTester;
    protected Predicate<DriveInfo> driveNotClaimed;
    protected ComputeServiceContext computeContext;
    protected String prefix = System.getProperty("user.name") + ".test";
    protected DriveInfo drive;
    protected ServerInfo server;

    public CloudSigmaClientLiveTest() {
        this.provider = "cloudsigma";
    }

    @BeforeGroups(groups={"live"})
    public void setupClient() {
        this.setupCredentials();
        Properties overrides = this.setupProperties();
        this.computeContext = new ComputeServiceContextFactory().createContext(this.provider, (Iterable)ImmutableSet.of((Object)new Log4JLoggingModule()), overrides);
        this.context = this.computeContext.getProviderSpecificContext();
        this.client = (CloudSigmaClient)this.context.getApi();
        this.driveNotClaimed = new RetryablePredicate(Predicates.not((Predicate)new DriveClaimed(this.client)), (long)this.maxDriveImageTime, 1L, TimeUnit.SECONDS);
        this.socketTester = new RetryablePredicate((Predicate)new InetSocketAddressConnect(), (long)this.maxDriveImageTime, 1L, TimeUnit.SECONDS);
        if (Strings.emptyToNull((String)this.imageId) == null) {
            this.imageId = this.computeContext.getComputeService().templateBuilder().build().getImage().getId();
        }
    }

    @Test
    public void testGetProfileInfo() throws Exception {
        ProfileInfo profile = this.client.getProfileInfo();
        Assert.assertNotNull((Object)profile);
    }

    @Test
    public void testListVLANs() throws Exception {
        Set vlans = this.client.listVLANs();
        Assert.assertNotNull((Object)vlans);
    }

    @Test
    public void testListVLANInfo() throws Exception {
        Set vlans = this.client.listVLANInfo();
        Assert.assertNotNull((Object)vlans);
    }

    @Test
    public void testGetVLAN() throws Exception {
        for (String vlanUUID : this.client.listVLANs()) {
            assert (!"".equals(vlanUUID));
            Assert.assertNotNull((Object)this.client.getVLANInfo(vlanUUID));
        }
    }

    @Test
    public void testListStaticIPs() throws Exception {
        Set ips = this.client.listStaticIPs();
        Assert.assertNotNull((Object)ips);
    }

    @Test
    public void testListStaticIPInfo() throws Exception {
        Set ips = this.client.listStaticIPInfo();
        Assert.assertNotNull((Object)ips);
    }

    @Test
    public void testGetStaticIP() throws Exception {
        for (String ipUUID : this.client.listStaticIPs()) {
            assert (!"".equals(ipUUID));
            Assert.assertNotNull((Object)this.client.getStaticIPInfo(ipUUID));
        }
    }

    @Test
    public void testListServers() throws Exception {
        Set servers = this.client.listServers();
        Assert.assertNotNull((Object)servers);
    }

    @Test
    public void testListServerInfo() throws Exception {
        Set servers = this.client.listServerInfo();
        Assert.assertNotNull((Object)servers);
    }

    @Test
    public void testGetServer() throws Exception {
        for (String serverUUID : this.client.listServers()) {
            assert (!"".equals(serverUUID));
            Assert.assertNotNull((Object)this.client.getServerInfo(serverUUID));
        }
    }

    @Test
    public void testListDrives() throws Exception {
        Set drives = this.client.listDrives();
        Assert.assertNotNull((Object)drives);
    }

    @Test
    public void testListDriveInfo() throws Exception {
        Set drives = this.client.listDriveInfo();
        Assert.assertNotNull((Object)drives);
    }

    @Test
    public void testGetDrive() throws Exception {
        for (String driveUUID : this.client.listStandardDrives()) {
            assert (!"".equals(driveUUID));
            DriveInfo drive = this.client.getDriveInfo(driveUUID);
            Assert.assertNotNull((Object)drive);
            assert (!drive.getType().equals((Object)DriveType.UNRECOGNIZED)) : drive;
            if (drive.getType() != DriveType.DISK || !drive.getDriveType().contains("preinstalled")) continue;
            System.out.println(drive.getName());
        }
    }

    @Test
    public void testCreateDrive() throws Exception {
        this.drive = this.client.createDrive((Drive)new CreateDriveRequest.Builder().name(this.prefix).size(this.driveSize).build());
        this.checkCreatedDrive();
        DriveInfo newInfo = this.client.getDriveInfo(this.drive.getUuid());
        this.checkDriveMatchesGet(newInfo);
    }

    protected void checkDriveMatchesGet(DriveInfo newInfo) {
        Assert.assertEquals((String)newInfo.getUuid(), (String)this.drive.getUuid());
        Assert.assertEquals((Object)newInfo.getType(), (Object)DriveType.DISK);
    }

    protected void checkCreatedDrive() {
        Assert.assertNotNull((Object)this.drive.getUuid());
        Assert.assertNotNull((Object)this.drive.getUser());
        Assert.assertEquals((String)this.drive.getName(), (String)this.prefix);
        Assert.assertEquals((long)this.drive.getSize(), (long)this.driveSize);
        Assert.assertEquals((Object)this.drive.getStatus(), (Object)DriveStatus.ACTIVE);
        Assert.assertEquals((String)this.drive.getEncryptionCipher(), (String)"aes-xts-plain");
        Assert.assertEquals((Object)this.drive.getType(), null);
    }

    @Test(dependsOnMethods={"testCreateDrive"})
    public void testSetDriveData() throws Exception {
        DriveInfo drive2 = this.client.setDriveData(this.drive.getUuid(), new DriveData.Builder().claimType(ClaimType.SHARED).name("rediculous").readers((Iterable)ImmutableSet.of((Object)"ffffffff-ffff-ffff-ffff-ffffffffffff")).use((Iterable)ImmutableSet.of((Object)"networking", (Object)"security", (Object)"gateway")).build());
        Assert.assertNotNull((Object)drive2.getUuid(), (String)this.drive.getUuid());
        Assert.assertEquals((String)drive2.getName(), (String)"rediculous");
        Assert.assertEquals((Object)drive2.getClaimType(), (Object)ClaimType.SHARED);
        Assert.assertEquals((Set)drive2.getReaders(), (Set)ImmutableSet.of((Object)"ffffffff-ffff-ffff-ffff-ffffffffffff"));
        Assert.assertEquals((Set)drive2.getUse(), (Set)ImmutableSet.of((Object)"networking", (Object)"security", (Object)"gateway"));
        this.drive = drive2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateAndDestroyVLAN() throws Exception {
        VLANInfo vlan = this.client.createVLAN(this.prefix);
        String id = vlan.getUuid();
        try {
            vlan = this.client.getVLANInfo(vlan.getUuid());
            Assert.assertEquals((String)vlan.getName(), (String)this.prefix);
            String prefix2 = this.prefix + "2";
            vlan = this.client.renameVLAN(vlan.getUuid(), prefix2);
            Assert.assertEquals((String)vlan.getName(), (String)prefix2);
        }
        finally {
            this.client.destroyVLAN(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dependsOnMethods={"testSetDriveData"})
    public void testCreateAndDestroyStaticIP() throws Exception {
        StaticIPInfo ip = this.client.createStaticIP();
        StaticIPInfo ip2 = this.client.createStaticIP();
        ServerInfo server = null;
        try {
            ip = this.client.getStaticIPInfo(ip.getAddress());
            Assert.assertNotNull((Object)ip);
            Logger.getAnonymousLogger().info("preparing drive");
            this.prepareDrive();
            Server serverRequest = Servers.smallWithStaticIP((String)this.prefix, (String)this.drive.getUuid(), (String)this.vncPassword, (String)ip.getAddress()).build();
            Logger.getAnonymousLogger().info("starting server");
            server = this.client.createServer(serverRequest);
            Assert.assertEquals((String)((NIC)server.getNics().get(0)).getDhcp(), (String)ip.getAddress());
            this.client.stopServer(server.getUuid());
            server = this.client.setServerConfiguration(server.getUuid(), Servers.changeIP((Server)server, (String)ip2.getAddress()));
            Assert.assertEquals((String)((NIC)server.getNics().get(0)).getDhcp(), (String)ip2.getAddress());
        }
        finally {
            if (server != null) {
                this.client.destroyServer(server.getUuid());
                this.client.destroyDrive(this.drive.getUuid());
            }
            this.client.destroyStaticIP(ip.getAddress());
            this.client.destroyStaticIP(ip2.getAddress());
        }
    }

    @Test(dependsOnMethods={"testCreateAndDestroyStaticIP"})
    public void testCreateAndStartServer() throws Exception {
        Logger.getAnonymousLogger().info("preparing drive");
        this.prepareDrive();
        Server serverRequest = Servers.small((String)this.prefix, (String)this.drive.getUuid(), (String)this.vncPassword).build();
        Logger.getAnonymousLogger().info("starting server");
        this.server = this.client.createServer(serverRequest);
        this.client.startServer(this.server.getUuid());
        this.server = this.client.getServerInfo(this.server.getUuid());
        this.checkStartedServer();
        ServerInfo newInfo = this.client.getServerInfo(this.server.getUuid());
        this.checkServerMatchesGet((Server)newInfo);
    }

    protected void checkServerMatchesGet(Server newInfo) {
        Assert.assertEquals((String)newInfo.getUuid(), (String)this.server.getUuid());
    }

    protected void checkStartedServer() {
        System.out.println(new Gson().toJson((Object)this.server));
        Assert.assertNotNull((Object)this.server.getUuid());
        Assert.assertNotNull((Object)this.server.getUser());
        Assert.assertEquals((String)this.server.getName(), (String)this.prefix);
        Assert.assertEquals((boolean)this.server.isPersistent(), (boolean)true);
        Assert.assertEquals((Map)this.server.getDevices(), (Map)ImmutableMap.of((Object)"ide:0:0", (Object)new IDEDevice.Builder(0, 0).uuid(this.drive.getUuid()).build()));
        Assert.assertEquals((Set)this.server.getBootDeviceIds(), (Set)ImmutableSet.of((Object)"ide:0:0"));
        Assert.assertEquals((String)((NIC)this.server.getNics().get(0)).getDhcp(), (String)this.server.getVnc().getIp());
        Assert.assertEquals((Object)((NIC)this.server.getNics().get(0)).getModel(), (Object)Model.E1000);
        Assert.assertEquals((Object)this.server.getStatus(), (Object)ServerStatus.ACTIVE);
    }

    @Test(dependsOnMethods={"testCreateAndStartServer"})
    public void testConnectivity() throws Exception {
        Logger.getAnonymousLogger().info("awaiting vnc");
        assert (this.socketTester.apply((Object)new IPSocket(this.server.getVnc().getIp(), 5900))) : this.server;
        Logger.getAnonymousLogger().info("awaiting ssh");
        assert (this.socketTester.apply((Object)new IPSocket(((NIC)this.server.getNics().get(0)).getDhcp(), 22))) : this.server;
        this.doConnectViaSsh((Server)this.server, this.getSshCredentials((Server)this.server));
    }

    @Test(dependsOnMethods={"testConnectivity"})
    public void testLifeCycle() throws Exception {
        this.client.stopServer(this.server.getUuid());
        Assert.assertEquals((Object)this.client.getServerInfo(this.server.getUuid()).getStatus(), (Object)ServerStatus.STOPPED);
        this.client.startServer(this.server.getUuid());
        Assert.assertEquals((Object)this.client.getServerInfo(this.server.getUuid()).getStatus(), (Object)ServerStatus.ACTIVE);
        this.client.resetServer(this.server.getUuid());
        Assert.assertEquals((Object)this.client.getServerInfo(this.server.getUuid()).getStatus(), (Object)ServerStatus.ACTIVE);
        this.client.shutdownServer(this.server.getUuid());
        assert (this.client.getServerInfo(this.server.getUuid()).getStatus() == ServerStatus.ACTIVE || this.client.getServerInfo(this.server.getUuid()).getStatus() == ServerStatus.STOPPED);
    }

    @Test(dependsOnMethods={"testLifeCycle"})
    public void testSetServerConfiguration() throws Exception {
        this.client.stopServer(this.server.getUuid());
        Assert.assertEquals((Object)this.client.getServerInfo(this.server.getUuid()).getStatus(), (Object)ServerStatus.STOPPED);
        ServerInfo server2 = this.client.setServerConfiguration(this.server.getUuid(), Server.Builder.fromServer((Server)this.server).name("rediculous").use((Iterable)ImmutableSet.of((Object)"networking", (Object)"security", (Object)"gateway")).build());
        Assert.assertNotNull((Object)server2.getUuid(), (String)this.server.getUuid());
        Assert.assertEquals((String)server2.getName(), (String)"rediculous");
        this.checkUse(server2);
        this.server = server2;
    }

    protected void checkUse(ServerInfo server2) {
        Assert.assertEquals((Set)server2.getUse(), (Set)ImmutableSet.of());
    }

    @Test(dependsOnMethods={"testSetServerConfiguration"})
    public void testDestroyServer() throws Exception {
        this.client.destroyServer(this.server.getUuid());
        Assert.assertEquals((Object)this.client.getServerInfo(this.server.getUuid()), null);
    }

    @Test(dependsOnMethods={"testDestroyServer"})
    public void testDestroyDrive() throws Exception {
        this.client.destroyDrive(this.drive.getUuid());
        Assert.assertEquals((Object)this.client.getDriveInfo(this.drive.getUuid()), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doConnectViaSsh(Server server, LoginCredentials creds) throws IOException {
        SshClient ssh = ((SshClient.Factory)Guice.createInjector((Module[])new Module[]{new SshjSshClientModule()}).getInstance(SshClient.Factory.class)).create(new IPSocket(server.getVnc().getIp(), 22), creds);
        try {
            ssh.connect();
            ExecResponse hello = ssh.exec("echo hello");
            Assert.assertEquals((String)hello.getOutput().trim(), (String)"hello");
            System.err.println(ssh.exec("df -k").getOutput());
            System.err.println(ssh.exec("mount").getOutput());
            System.err.println(ssh.exec("uname -a").getOutput());
        }
        finally {
            if (ssh != null) {
                ssh.disconnect();
            }
        }
    }

    @AfterGroups(groups={"live"})
    protected void tearDown() {
        if (this.server != null) {
            this.client.destroyServer(this.server.getUuid());
        }
        if (this.server != null) {
            this.client.destroyDrive(this.drive.getUuid());
        }
        if (this.context != null) {
            this.context.close();
        }
    }

    @Test
    public void testListStandardDrives() throws Exception {
        Set drives = this.client.listStandardDrives();
        Assert.assertNotNull((Object)drives);
    }

    @Test
    public void testListStandardCds() throws Exception {
        Set drives = this.client.listStandardCds();
        Assert.assertNotNull((Object)drives);
    }

    @Test
    public void testListStandardImages() throws Exception {
        Set drives = this.client.listStandardImages();
        Assert.assertNotNull((Object)drives);
    }

    protected LoginCredentials getSshCredentials(Server server) {
        return LoginCredentials.builder().user("root").password(this.vncPassword).build();
    }

    protected void prepareDrive() {
        this.client.destroyDrive(this.drive.getUuid());
        this.drive = this.client.cloneDrive(this.imageId, this.drive.getName(), new CloneDriveOptions[]{new CloneDriveOptions().size(this.driveSize).tags(new String[]{"cat:mouse", "monkey:banana"})});
        assert (this.driveNotClaimed.apply((Object)this.drive)) : this.client.getDriveInfo(this.drive.getUuid());
        DriveInfo clonedDrive = this.client.getDriveInfo(this.drive.getUuid());
        System.err.println("after prepare" + clonedDrive);
        Assert.assertEquals((Set)clonedDrive.getTags(), (Set)ImmutableSet.of((Object)"cat:mouse", (Object)"monkey:banana"));
    }
}

