/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudsigma;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.inject.TypeLiteral;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Properties;
import org.jclouds.cloudsigma.CloudSigmaAsyncClient;
import org.jclouds.cloudsigma.CloudSigmaClient;
import org.jclouds.cloudsigma.binders.BindServerToPlainTextStringTest;
import org.jclouds.cloudsigma.domain.CreateDriveRequest;
import org.jclouds.cloudsigma.domain.Drive;
import org.jclouds.cloudsigma.domain.DriveData;
import org.jclouds.cloudsigma.domain.Server;
import org.jclouds.cloudsigma.functions.KeyValuesDelimitedByBlankLinesToDriveInfo;
import org.jclouds.cloudsigma.functions.KeyValuesDelimitedByBlankLinesToProfileInfo;
import org.jclouds.cloudsigma.functions.KeyValuesDelimitedByBlankLinesToServerInfo;
import org.jclouds.cloudsigma.functions.KeyValuesDelimitedByBlankLinesToStaticIPInfo;
import org.jclouds.cloudsigma.functions.KeyValuesDelimitedByBlankLinesToVLANInfo;
import org.jclouds.cloudsigma.functions.ListOfKeyValuesDelimitedByBlankLinesToDriveInfoSet;
import org.jclouds.cloudsigma.functions.ListOfKeyValuesDelimitedByBlankLinesToServerInfoSet;
import org.jclouds.cloudsigma.functions.ListOfKeyValuesDelimitedByBlankLinesToStaticIPInfoSet;
import org.jclouds.cloudsigma.functions.ListOfKeyValuesDelimitedByBlankLinesToVLANInfoSet;
import org.jclouds.cloudsigma.functions.SplitNewlines;
import org.jclouds.cloudsigma.functions.SplitNewlinesAndReturnSecondField;
import org.jclouds.cloudsigma.options.CloneDriveOptions;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.http.filters.BasicAuthentication;
import org.jclouds.http.functions.ReleasePayloadAndReturn;
import org.jclouds.rest.RestClientTest;
import org.jclouds.rest.RestContextFactory;
import org.jclouds.rest.RestContextSpec;
import org.jclouds.rest.functions.MapHttp4xxCodesToExceptions;
import org.jclouds.rest.functions.ReturnNullOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnVoidOnNotFoundOr404;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.rest.internal.RestAnnotationProcessor;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="CloudSigmaAsyncClientTest")
public class CloudSigmaAsyncClientTest
extends RestClientTest<CloudSigmaAsyncClient> {
    public void testGetProfileInfo() throws SecurityException, NoSuchMethodException, IOException {
        Method method = CloudSigmaAsyncClient.class.getMethod("getProfileInfo", new Class[0]);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[0]);
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.cloudsigma.com/profile/info HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, KeyValuesDelimitedByBlankLinesToProfileInfo.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnNullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testListStandardDrives() throws SecurityException, NoSuchMethodException, IOException {
        Method method = CloudSigmaAsyncClient.class.getMethod("listStandardDrives", new Class[0]);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[0]);
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.cloudsigma.com/drives/standard/list HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, SplitNewlines.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, null);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testListStandardCds() throws SecurityException, NoSuchMethodException, IOException {
        Method method = CloudSigmaAsyncClient.class.getMethod("listStandardCds", new Class[0]);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[0]);
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.cloudsigma.com/drives/standard/cd/list HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, SplitNewlines.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, null);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testListStandardImages() throws SecurityException, NoSuchMethodException, IOException {
        Method method = CloudSigmaAsyncClient.class.getMethod("listStandardImages", new Class[0]);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[0]);
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.cloudsigma.com/drives/standard/img/list HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, SplitNewlines.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, null);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testListDriveInfo() throws SecurityException, NoSuchMethodException, IOException {
        Method method = CloudSigmaAsyncClient.class.getMethod("listDriveInfo", new Class[0]);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[0]);
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.cloudsigma.com/drives/info HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, ListOfKeyValuesDelimitedByBlankLinesToDriveInfoSet.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, null);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testGetDriveInfo() throws SecurityException, NoSuchMethodException, IOException {
        Method method = CloudSigmaAsyncClient.class.getMethod("getDriveInfo", String.class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{"uuid"});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.cloudsigma.com/drives/uuid/info HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, KeyValuesDelimitedByBlankLinesToDriveInfo.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnNullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testCreateDrive() throws SecurityException, NoSuchMethodException, IOException {
        Method method = CloudSigmaAsyncClient.class.getMethod("createDrive", Drive.class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{new CreateDriveRequest.Builder().name("foo").use((Iterable)ImmutableList.of((Object)"production", (Object)"candy")).size(10000L).build()});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "POST https://api.cloudsigma.com/drives/create HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, "name foo\nsize 10000\nuse production candy", "text/plain", false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, KeyValuesDelimitedByBlankLinesToDriveInfo.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnNullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testCloneDrive() throws SecurityException, NoSuchMethodException, IOException {
        Method method = CloudSigmaAsyncClient.class.getMethod("cloneDrive", String.class, String.class, CloneDriveOptions[].class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{"sourceid", "newname"});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "POST https://api.cloudsigma.com/drives/sourceid/clone HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, "name newname", "text/plain", false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, KeyValuesDelimitedByBlankLinesToDriveInfo.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, MapHttp4xxCodesToExceptions.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testCloneDriveOptions() throws SecurityException, NoSuchMethodException, IOException {
        Method method = CloudSigmaAsyncClient.class.getMethod("cloneDrive", String.class, String.class, CloneDriveOptions[].class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{"sourceid", "newname", new CloneDriveOptions().size(1024L)});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "POST https://api.cloudsigma.com/drives/sourceid/clone HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, "name newname\nsize 1024", "text/plain", false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, KeyValuesDelimitedByBlankLinesToDriveInfo.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, MapHttp4xxCodesToExceptions.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testSetDriveData() throws SecurityException, NoSuchMethodException, IOException {
        Method method = CloudSigmaAsyncClient.class.getMethod("setDriveData", String.class, DriveData.class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{"100", new DriveData.Builder().name("foo").size(10000L).use((Iterable)ImmutableList.of((Object)"production", (Object)"candy")).build()});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "POST https://api.cloudsigma.com/drives/100/set HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, "name foo\nsize 10000\nuse production candy", "text/plain", false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, KeyValuesDelimitedByBlankLinesToDriveInfo.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, MapHttp4xxCodesToExceptions.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testListServers() throws SecurityException, NoSuchMethodException, IOException {
        Method method = CloudSigmaAsyncClient.class.getMethod("listServers", new Class[0]);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[0]);
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.cloudsigma.com/servers/list HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        httpRequest = ((HttpRequestFilter)Iterables.getOnlyElement((Iterable)httpRequest.getFilters())).filter((HttpRequest)httpRequest);
        httpRequest = ((HttpRequestFilter)Iterables.getOnlyElement((Iterable)httpRequest.getFilters())).filter((HttpRequest)httpRequest);
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.cloudsigma.com/servers/list HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\nAuthorization: Basic Zm9vOmJhcg==\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, SplitNewlines.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, null);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testListServerInfo() throws SecurityException, NoSuchMethodException, IOException {
        Method method = CloudSigmaAsyncClient.class.getMethod("listServerInfo", new Class[0]);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[0]);
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.cloudsigma.com/servers/info HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, ListOfKeyValuesDelimitedByBlankLinesToServerInfoSet.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, null);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testGetServerInfo() throws SecurityException, NoSuchMethodException, IOException {
        Method method = CloudSigmaAsyncClient.class.getMethod("getServerInfo", String.class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{"uuid"});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.cloudsigma.com/servers/uuid/info HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, KeyValuesDelimitedByBlankLinesToServerInfo.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnNullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testCreateServer() throws SecurityException, NoSuchMethodException, IOException {
        Method method = CloudSigmaAsyncClient.class.getMethod("createServer", Server.class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{BindServerToPlainTextStringTest.SERVER});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "POST https://api.cloudsigma.com/servers/create HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, BindServerToPlainTextStringTest.CREATED_SERVER, "text/plain", false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, KeyValuesDelimitedByBlankLinesToServerInfo.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnNullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testSetServerConfiguration() throws SecurityException, NoSuchMethodException, IOException {
        Method method = CloudSigmaAsyncClient.class.getMethod("setServerConfiguration", String.class, Server.class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{"100", BindServerToPlainTextStringTest.SERVER});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "POST https://api.cloudsigma.com/servers/100/set HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, BindServerToPlainTextStringTest.CREATED_SERVER, "text/plain", false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, KeyValuesDelimitedByBlankLinesToServerInfo.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnNullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testDestroyServer() throws SecurityException, NoSuchMethodException, IOException {
        Method method = CloudSigmaAsyncClient.class.getMethod("destroyServer", String.class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{"uuid"});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.cloudsigma.com/servers/uuid/destroy HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnVoidOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testStartServer() throws SecurityException, NoSuchMethodException, IOException {
        Method method = CloudSigmaAsyncClient.class.getMethod("startServer", String.class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{"uuid"});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "POST https://api.cloudsigma.com/servers/uuid/start HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, MapHttp4xxCodesToExceptions.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testStopServer() throws SecurityException, NoSuchMethodException, IOException {
        Method method = CloudSigmaAsyncClient.class.getMethod("stopServer", String.class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{"uuid"});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "POST https://api.cloudsigma.com/servers/uuid/stop HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, MapHttp4xxCodesToExceptions.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testShutdownServer() throws SecurityException, NoSuchMethodException, IOException {
        Method method = CloudSigmaAsyncClient.class.getMethod("shutdownServer", String.class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{"uuid"});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "POST https://api.cloudsigma.com/servers/uuid/shutdown HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, MapHttp4xxCodesToExceptions.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testResetServer() throws SecurityException, NoSuchMethodException, IOException {
        Method method = CloudSigmaAsyncClient.class.getMethod("resetServer", String.class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{"uuid"});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "POST https://api.cloudsigma.com/servers/uuid/reset HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, MapHttp4xxCodesToExceptions.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testListDrives() throws SecurityException, NoSuchMethodException, IOException {
        Method method = CloudSigmaAsyncClient.class.getMethod("listDrives", new Class[0]);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[0]);
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.cloudsigma.com/drives/list HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        httpRequest = ((HttpRequestFilter)Iterables.getOnlyElement((Iterable)httpRequest.getFilters())).filter((HttpRequest)httpRequest);
        httpRequest = ((HttpRequestFilter)Iterables.getOnlyElement((Iterable)httpRequest.getFilters())).filter((HttpRequest)httpRequest);
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.cloudsigma.com/drives/list HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\nAuthorization: Basic Zm9vOmJhcg==\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, SplitNewlines.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, null);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testDestroyDrive() throws SecurityException, NoSuchMethodException, IOException {
        Method method = CloudSigmaAsyncClient.class.getMethod("destroyDrive", String.class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{"uuid"});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.cloudsigma.com/drives/uuid/destroy HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnVoidOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testListVLANs() throws SecurityException, NoSuchMethodException, IOException {
        Method method = CloudSigmaAsyncClient.class.getMethod("listVLANs", new Class[0]);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[0]);
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.cloudsigma.com/resources/vlan/list HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        httpRequest = ((HttpRequestFilter)Iterables.getOnlyElement((Iterable)httpRequest.getFilters())).filter((HttpRequest)httpRequest);
        httpRequest = ((HttpRequestFilter)Iterables.getOnlyElement((Iterable)httpRequest.getFilters())).filter((HttpRequest)httpRequest);
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.cloudsigma.com/resources/vlan/list HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\nAuthorization: Basic Zm9vOmJhcg==\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, SplitNewlinesAndReturnSecondField.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, null);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testListVLANInfo() throws SecurityException, NoSuchMethodException, IOException {
        Method method = CloudSigmaAsyncClient.class.getMethod("listVLANInfo", new Class[0]);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[0]);
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.cloudsigma.com/resources/vlan/info HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, ListOfKeyValuesDelimitedByBlankLinesToVLANInfoSet.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, null);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testGetVLANInfo() throws SecurityException, NoSuchMethodException, IOException {
        Method method = CloudSigmaAsyncClient.class.getMethod("getVLANInfo", String.class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{"uuid"});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.cloudsigma.com/resources/vlan/uuid/info HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, KeyValuesDelimitedByBlankLinesToVLANInfo.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnNullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testCreateVLAN() throws SecurityException, NoSuchMethodException, IOException {
        Method method = CloudSigmaAsyncClient.class.getMethod("createVLAN", String.class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{"poohbear"});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "POST https://api.cloudsigma.com/resources/vlan/create HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, "name poohbear\n", "text/plain", false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, KeyValuesDelimitedByBlankLinesToVLANInfo.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnNullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testRenameVLAN() throws SecurityException, NoSuchMethodException, IOException {
        Method method = CloudSigmaAsyncClient.class.getMethod("renameVLAN", String.class, String.class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{"100", "poohbear"});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "POST https://api.cloudsigma.com/resources/vlan/100/set HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, "name poohbear\n", "text/plain", false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, KeyValuesDelimitedByBlankLinesToVLANInfo.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, MapHttp4xxCodesToExceptions.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testDestroyVLAN() throws SecurityException, NoSuchMethodException, IOException {
        Method method = CloudSigmaAsyncClient.class.getMethod("destroyVLAN", String.class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{"uuid"});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.cloudsigma.com/resources/vlan/uuid/destroy HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnVoidOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testListStaticIPs() throws SecurityException, NoSuchMethodException, IOException {
        Method method = CloudSigmaAsyncClient.class.getMethod("listStaticIPs", new Class[0]);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[0]);
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.cloudsigma.com/resources/ip/list HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        httpRequest = ((HttpRequestFilter)Iterables.getOnlyElement((Iterable)httpRequest.getFilters())).filter((HttpRequest)httpRequest);
        httpRequest = ((HttpRequestFilter)Iterables.getOnlyElement((Iterable)httpRequest.getFilters())).filter((HttpRequest)httpRequest);
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.cloudsigma.com/resources/ip/list HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\nAuthorization: Basic Zm9vOmJhcg==\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, SplitNewlinesAndReturnSecondField.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, null);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testListStaticIPInfo() throws SecurityException, NoSuchMethodException, IOException {
        Method method = CloudSigmaAsyncClient.class.getMethod("listStaticIPInfo", new Class[0]);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[0]);
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.cloudsigma.com/resources/ip/info HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, ListOfKeyValuesDelimitedByBlankLinesToStaticIPInfoSet.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, null);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testGetStaticIPInfo() throws SecurityException, NoSuchMethodException, IOException {
        Method method = CloudSigmaAsyncClient.class.getMethod("getStaticIPInfo", String.class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{"uuid"});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.cloudsigma.com/resources/ip/uuid/info HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, KeyValuesDelimitedByBlankLinesToStaticIPInfo.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnNullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testCreateStaticIP() throws SecurityException, NoSuchMethodException, IOException {
        Method method = CloudSigmaAsyncClient.class.getMethod("createStaticIP", new Class[0]);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[0]);
        this.assertRequestLineEquals((HttpRequest)httpRequest, "POST https://api.cloudsigma.com/resources/ip/create HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, KeyValuesDelimitedByBlankLinesToStaticIPInfo.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnNullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testDestroyStaticIP() throws SecurityException, NoSuchMethodException, IOException {
        Method method = CloudSigmaAsyncClient.class.getMethod("destroyStaticIP", String.class);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, new Object[]{"uuid"});
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.cloudsigma.com/resources/ip/uuid/destroy HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)httpRequest, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnVoidOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    protected void checkFilters(HttpRequest request) {
        Assert.assertEquals((int)request.getFilters().size(), (int)1);
        Assert.assertEquals(((HttpRequestFilter)request.getFilters().get(0)).getClass(), BasicAuthentication.class);
    }

    protected TypeLiteral<RestAnnotationProcessor<CloudSigmaAsyncClient>> createTypeLiteral() {
        return new TypeLiteral<RestAnnotationProcessor<CloudSigmaAsyncClient>>(){};
    }

    public RestContextSpec<CloudSigmaClient, CloudSigmaAsyncClient> createContextSpec() {
        Properties props = new Properties();
        props.setProperty("cloudsigma.endpoint", "https://api.cloudsigma.com");
        return new RestContextFactory().createContextSpec("cloudsigma", "foo", "bar", props);
    }
}

