/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudsigma.options;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;

public class CloneDriveOptions {
    private final Map<String, String> options = Maps.newLinkedHashMap();

    public CloneDriveOptions size(long size) {
        Preconditions.checkArgument((size >= 0L ? 1 : 0) != 0, (Object)"size must be >= 0");
        this.options.put("size", size + "");
        return this;
    }

    public Map<String, String> getOptions() {
        return ImmutableMap.copyOf(this.options);
    }

    public static class Builder {
        public static CloneDriveOptions size(long size) {
            CloneDriveOptions options = new CloneDriveOptions();
            return options.size(size);
        }
    }
}

