/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudsigma.domain;

import com.google.common.base.Preconditions;
import org.jclouds.javax.annotation.Nullable;

public class VLANInfo {
    @Nullable
    protected final String uuid;
    protected final String name;
    protected final String user;

    public VLANInfo(String uuid, String name, String user) {
        this.uuid = (String)Preconditions.checkNotNull((Object)uuid, (Object)"uuid");
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.user = (String)Preconditions.checkNotNull((Object)user, (Object)"user");
    }

    @Nullable
    public String getUuid() {
        return this.uuid;
    }

    public String getName() {
        return this.name;
    }

    public String getUser() {
        return this.user;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.user == null ? 0 : this.user.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VLANInfo other = (VLANInfo)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.user == null ? other.user != null : !this.user.equals(other.user));
    }

    public String toString() {
        return "[uuid=" + this.uuid + ", name=" + this.name + ", user=" + this.user + "]";
    }

    public static class Builder {
        protected String uuid;
        protected String name;
        protected String user;

        public Builder uuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder user(String user) {
            this.user = user;
            return this;
        }

        public VLANInfo build() {
            return new VLANInfo(this.uuid, this.name, this.user);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.user == null ? 0 : this.user.hashCode());
            result = 31 * result + (this.uuid == null ? 0 : this.uuid.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Builder other = (Builder)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.user == null ? other.user != null : !this.user.equals(other.user)) {
                return false;
            }
            return !(this.uuid == null ? other.uuid != null : !this.uuid.equals(other.uuid));
        }
    }
}

