/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudservers.options;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.Map;
import org.jclouds.cloudservers.options.CreateServerOptions;
import org.jclouds.http.HttpRequest;
import org.jclouds.json.config.GsonModule;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class CreateServerOptionsTest {
    Injector injector = Guice.createInjector((Module[])new Module[]{new GsonModule()});

    @Test
    public void testAddPayloadToRequestMapOfStringStringHttpRequest() {
        CreateServerOptions options = new CreateServerOptions();
        HttpRequest request = this.buildRequest(options);
        Assert.assertEquals((Object)"{\"server\":{\"name\":\"foo\",\"imageId\":1,\"flavorId\":2}}", (Object)request.getPayload().getRawContent());
    }

    private HttpRequest buildRequest(CreateServerOptions options) {
        this.injector.injectMembers((Object)options);
        HttpRequest request = HttpRequest.builder().method("POST").endpoint("http://localhost").build();
        options.bindToRequest(request, (Map)ImmutableMap.of((Object)"name", (Object)"foo", (Object)"imageId", (Object)"1", (Object)"flavorId", (Object)"2"));
        return request;
    }

    @Test
    public void testWithFile() {
        CreateServerOptions options = new CreateServerOptions();
        options.withFile("/tmp/rhubarb", "foo".getBytes());
        HttpRequest request = this.buildRequest(options);
        this.assertFile(request);
    }

    @Test
    public void testWithFileStatic() {
        CreateServerOptions options = CreateServerOptions.Builder.withFile((String)"/tmp/rhubarb", (byte[])"foo".getBytes());
        HttpRequest request = this.buildRequest(options);
        this.assertFile(request);
    }

    private void assertFile(HttpRequest request) {
        Assert.assertEquals((Object)"{\"server\":{\"name\":\"foo\",\"imageId\":1,\"flavorId\":2,\"personality\":[{\"path\":\"/tmp/rhubarb\",\"contents\":\"Zm9v\"}]}}", (Object)request.getPayload().getRawContent());
    }

    @Test
    public void testWithSharedIpGroup() {
        CreateServerOptions options = new CreateServerOptions();
        options.withSharedIpGroup(3);
        HttpRequest request = this.buildRequest(options);
        this.assertSharedIpGroup(request);
    }

    @Test
    public void testWithSharedIpGroupStatic() {
        CreateServerOptions options = CreateServerOptions.Builder.withSharedIpGroup((int)3);
        HttpRequest request = this.buildRequest(options);
        this.assertSharedIpGroup(request);
    }

    private void assertSharedIpGroup(HttpRequest request) {
        Assert.assertEquals((Object)"{\"server\":{\"name\":\"foo\",\"imageId\":1,\"flavorId\":2,\"sharedIpGroupId\":3}}", (Object)request.getPayload().getRawContent());
    }

    @Test
    public void testWithMetadata() {
    }

    @Test
    public void testWithSharedIp() {
        CreateServerOptions options = new CreateServerOptions();
        options.withSharedIpGroup(3).withSharedIp("127.0.0.1");
        HttpRequest request = this.buildRequest(options);
        this.assertSharedIp(request);
    }

    @Test
    public void testWithSharedIpStatic() {
        CreateServerOptions options = CreateServerOptions.Builder.withSharedIpGroup((int)3).withSharedIp("127.0.0.1");
        HttpRequest request = this.buildRequest(options);
        this.assertSharedIp(request);
    }

    private void assertSharedIp(HttpRequest request) {
        Assert.assertEquals((Object)"{\"server\":{\"name\":\"foo\",\"imageId\":1,\"flavorId\":2,\"sharedIpGroupId\":3,\"addresses\":{\"public\":[\"127.0.0.1\"]}}}", (Object)request.getPayload().getRawContent());
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testWithSharedIpNoGroup() {
        CreateServerOptions options = new CreateServerOptions();
        options.withSharedIp("127.0.0.1");
        this.buildRequest(options);
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testWithSharedIpNoGroupStatic() {
        CreateServerOptions options = CreateServerOptions.Builder.withSharedIp((String)"127.0.0.1");
        this.buildRequest(options);
    }
}

