/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudservers.compute.extensions;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.UncheckedTimeoutException;
import java.util.NoSuchElementException;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.cloudservers.CloudServersClient;
import org.jclouds.cloudservers.domain.Image;
import org.jclouds.cloudservers.domain.Server;
import org.jclouds.compute.domain.CloneImageTemplate;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.ImageBuilder;
import org.jclouds.compute.domain.ImageTemplate;
import org.jclouds.compute.domain.ImageTemplateBuilder;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.extensions.ImageExtension;
import org.jclouds.domain.Location;
import org.jclouds.logging.Logger;

@Singleton
public class CloudServersImageExtension
implements ImageExtension {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final CloudServersClient client;
    private final ListeningExecutorService userExecutor;
    private final Supplier<Location> location;
    private final Predicate<AtomicReference<org.jclouds.compute.domain.Image>> imageAvailablePredicate;

    @Inject
    public CloudServersImageExtension(CloudServersClient client, @Named(value="jclouds.user-threads") ListeningExecutorService userExecutor, Supplier<Location> location, @Named(value="jclouds.compute.timeout.image-available") Predicate<AtomicReference<org.jclouds.compute.domain.Image>> imageAvailablePredicate) {
        this.client = (CloudServersClient)Preconditions.checkNotNull((Object)client, (Object)"client");
        this.userExecutor = (ListeningExecutorService)Preconditions.checkNotNull((Object)userExecutor, (Object)"userExecutor");
        this.location = (Supplier)Preconditions.checkNotNull(location, (Object)"location");
        this.imageAvailablePredicate = (Predicate)Preconditions.checkNotNull(imageAvailablePredicate, (Object)"imageAvailablePredicate");
    }

    public ImageTemplate buildImageTemplateFromNode(String name, String id) {
        Server server = this.client.getServer(Integer.parseInt(id));
        if (server == null) {
            throw new NoSuchElementException("Cannot find server with id: " + id);
        }
        CloneImageTemplate template = new ImageTemplateBuilder.CloneImageTemplateBuilder().nodeId(id).name(name).build();
        return template;
    }

    public ListenableFuture<org.jclouds.compute.domain.Image> createImage(ImageTemplate template) {
        Preconditions.checkState((boolean)(template instanceof CloneImageTemplate), (Object)" openstack-nova only supports creating images through cloning.");
        CloneImageTemplate cloneTemplate = (CloneImageTemplate)template;
        Image csImage = this.client.createImageFromServer(cloneTemplate.getName(), Integer.parseInt(cloneTemplate.getSourceNodeId()));
        final AtomicReference<org.jclouds.compute.domain.Image> image = new AtomicReference<org.jclouds.compute.domain.Image>(new ImageBuilder().location((Location)this.location.get()).ids(csImage.getId() + "").description(cloneTemplate.getName()).operatingSystem(OperatingSystem.builder().description(cloneTemplate.getName()).build()).status(Image.Status.PENDING).build());
        return this.userExecutor.submit((Callable)new Callable<org.jclouds.compute.domain.Image>(){

            @Override
            public org.jclouds.compute.domain.Image call() throws Exception {
                if (CloudServersImageExtension.this.imageAvailablePredicate.apply((Object)image)) {
                    return (org.jclouds.compute.domain.Image)image.get();
                }
                throw new UncheckedTimeoutException("Image was not created within the time limit: " + image.get());
            }
        });
    }

    public boolean deleteImage(String id) {
        try {
            this.client.deleteImage(Integer.parseInt(id));
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

