/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudservers.options;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Date;
import org.jclouds.cloudservers.options.ListOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class ListOptionsTest {
    public void testWithDetails() {
        ListOptions options = new ListOptions().withDetails();
        Assert.assertEquals((String)options.buildPathSuffix(), (String)"/detail");
    }

    public void testWithDetailsStatic() {
        ListOptions options = ListOptions.Builder.withDetails();
        Assert.assertEquals((String)options.buildPathSuffix(), (String)"/detail");
    }

    public void testChangesSince() {
        Date ifModifiedSince = new Date();
        ListOptions options = new ListOptions().changesSince(ifModifiedSince);
        Assert.assertEquals((Collection)ImmutableList.of((Object)(ifModifiedSince.getTime() / 1000L + "")), (Collection)options.buildQueryParameters().get((Object)"changes-since"));
    }

    public void testStartAt() {
        long offset = 1L;
        ListOptions options = new ListOptions().startAt(offset);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"1"), (Collection)options.buildQueryParameters().get((Object)"offset"));
    }

    public void testMaxResults() {
        int limit = 1;
        ListOptions options = new ListOptions().maxResults(limit);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"1"), (Collection)options.buildQueryParameters().get((Object)"limit"));
    }

    public void testChangesSinceStatic() {
        Date ifModifiedSince = new Date();
        ListOptions options = ListOptions.Builder.changesSince((Date)ifModifiedSince);
        Assert.assertEquals((Collection)ImmutableList.of((Object)(ifModifiedSince.getTime() / 1000L + "")), (Collection)options.buildQueryParameters().get((Object)"changes-since"));
    }

    public void testStartAtStatic() {
        long offset = 1L;
        ListOptions options = ListOptions.Builder.startAt((long)offset);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"1"), (Collection)options.buildQueryParameters().get((Object)"offset"));
    }

    public void testMaxResultsStatic() {
        int limit = 1;
        ListOptions options = ListOptions.Builder.maxResults((int)limit);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"1"), (Collection)options.buildQueryParameters().get((Object)"limit"));
    }
}

