/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudservers.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import org.jclouds.cloudservers.domain.RateLimitUnit;
import org.jclouds.javax.annotation.Nullable;

public class RateLimit {
    private final String uri;
    private final String regex;
    private final int remaining;
    private final long resetTime;
    private final RateLimitUnit unit;
    private final int value;
    private final String verb;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromRateLimit(this);
    }

    @ConstructorProperties(value={"uri", "regex", "remaining", "resetTime", "unit", "value", "verb"})
    protected RateLimit(String uri, @Nullable String regex, int remaining, long resetTime, @Nullable RateLimitUnit unit, int value, @Nullable String verb) {
        this.uri = (String)Preconditions.checkNotNull((Object)uri, (Object)"uri");
        this.regex = regex;
        this.remaining = remaining;
        this.resetTime = resetTime;
        this.unit = unit;
        this.value = value;
        this.verb = verb;
    }

    public String getUri() {
        return this.uri;
    }

    @Nullable
    public String getRegex() {
        return this.regex;
    }

    public int getRemaining() {
        return this.remaining;
    }

    public long getResetTime() {
        return this.resetTime;
    }

    @Nullable
    public RateLimitUnit getUnit() {
        return this.unit;
    }

    public int getValue() {
        return this.value;
    }

    @Nullable
    public String getVerb() {
        return this.verb;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.uri, this.regex, this.remaining, this.resetTime, this.unit, this.value, this.verb});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RateLimit that = (RateLimit)RateLimit.class.cast(obj);
        return Objects.equal((Object)this.uri, (Object)that.uri) && Objects.equal((Object)this.regex, (Object)that.regex) && Objects.equal((Object)this.remaining, (Object)that.remaining) && Objects.equal((Object)this.resetTime, (Object)that.resetTime) && Objects.equal((Object)((Object)this.unit), (Object)((Object)that.unit)) && Objects.equal((Object)this.value, (Object)that.value) && Objects.equal((Object)this.verb, (Object)that.verb);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).add("uri", (Object)this.uri).add("regex", (Object)this.regex).add("remaining", this.remaining).add("resetTime", this.resetTime).add("unit", (Object)this.unit).add("value", this.value).add("verb", (Object)this.verb);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String uri;
        protected String regex;
        protected int remaining;
        protected long resetTime;
        protected RateLimitUnit unit;
        protected int value;
        protected String verb;

        protected abstract T self();

        public T uri(String uri) {
            this.uri = uri;
            return this.self();
        }

        public T regex(String regex) {
            this.regex = regex;
            return this.self();
        }

        public T remaining(int remaining) {
            this.remaining = remaining;
            return this.self();
        }

        public T resetTime(long resetTime) {
            this.resetTime = resetTime;
            return this.self();
        }

        public T unit(RateLimitUnit unit) {
            this.unit = unit;
            return this.self();
        }

        public T value(int value) {
            this.value = value;
            return this.self();
        }

        public T verb(String verb) {
            this.verb = verb;
            return this.self();
        }

        public RateLimit build() {
            return new RateLimit(this.uri, this.regex, this.remaining, this.resetTime, this.unit, this.value, this.verb);
        }

        public T fromRateLimit(RateLimit in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.uri(in.getUri())).regex(in.getRegex())).remaining(in.getRemaining())).resetTime(in.getResetTime())).unit(in.getUnit())).value(in.getValue())).verb(in.getVerb());
        }
    }
}

