/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudservers.functions;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import java.io.InputStream;
import java.net.UnknownHostException;
import org.jclouds.cloudservers.domain.Image;
import org.jclouds.cloudservers.domain.ImageStatus;
import org.jclouds.date.DateService;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.UnwrapOnlyJsonValue;
import org.jclouds.json.config.GsonModule;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class ParseImageFromJsonResponseTest {
    Injector i = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

        protected void configure() {
            this.bind(GsonModule.DateAdapter.class).to(GsonModule.Iso8601DateAdapter.class);
        }
    }, new GsonModule()});
    DateService dateService = (DateService)this.i.getInstance(DateService.class);

    public void testApplyInputStreamDetails() throws UnknownHostException {
        Image response = ParseImageFromJsonResponseTest.parseImage();
        Assert.assertEquals((int)response.getId(), (int)2);
        Assert.assertEquals((String)response.getName(), (String)"CentOS 5.2");
        Assert.assertEquals((Object)response.getCreated(), (Object)this.dateService.iso8601SecondsDateParse("2010-08-10T12:00:00Z"));
        Assert.assertEquals((Object)response.getProgress(), (Object)80);
        Assert.assertEquals((Object)response.getServerId(), (Object)12);
        Assert.assertEquals((Object)response.getStatus(), (Object)ImageStatus.SAVING);
        Assert.assertEquals((Object)response.getUpdated(), (Object)this.dateService.iso8601SecondsDateParse("2010-10-10T12:00:00Z"));
    }

    public static Image parseImage() {
        Injector i = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(GsonModule.DateAdapter.class).to(GsonModule.Iso8601DateAdapter.class);
            }
        }, new GsonModule()});
        InputStream is = ParseImageFromJsonResponseTest.class.getResourceAsStream("/test_get_image_details.json");
        UnwrapOnlyJsonValue parser = (UnwrapOnlyJsonValue)i.getInstance(Key.get((TypeLiteral)new TypeLiteral<UnwrapOnlyJsonValue<Image>>(){}));
        Image response = (Image)parser.apply(((HttpResponse.Builder)HttpResponse.builder().statusCode(200).message("ok").payload(is)).build());
        return response;
    }
}

