/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudservers.functions;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import java.io.InputStream;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.jclouds.cloudservers.domain.Addresses;
import org.jclouds.cloudservers.domain.Server;
import org.jclouds.cloudservers.domain.ServerStatus;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.UnwrapOnlyJsonValue;
import org.jclouds.json.config.GsonModule;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class ParseServerFromJsonResponseTest {
    public void testApplyInputStreamDetails() throws UnknownHostException {
        Server response = ParseServerFromJsonResponseTest.parseServer();
        Assert.assertEquals((int)response.getId(), (int)1234);
        Assert.assertEquals((String)response.getName(), (String)"sample-server");
        Assert.assertEquals((Object)response.getImageId(), (Object)2);
        Assert.assertEquals((Object)response.getFlavorId(), (Object)1);
        Assert.assertEquals((String)response.getHostId(), (String)"e4d909c290d0fb1ca068ffaddf22cbd0");
        Assert.assertEquals((Object)response.getStatus(), (Object)ServerStatus.BUILD);
        Assert.assertEquals((Object)response.getProgress(), (Object)60);
        ArrayList publicAddresses = Lists.newArrayList((Object[])new String[]{"67.23.10.132", "67.23.10.131"});
        ArrayList privateAddresses = Lists.newArrayList((Object[])new String[]{"10.176.42.16"});
        Addresses addresses1 = Addresses.builder().publicAddresses((Collection)publicAddresses).privateAddresses((Collection)privateAddresses).build();
        Assert.assertEquals((Object)response.getAddresses(), (Object)addresses1);
        Assert.assertEquals((Map)response.getMetadata(), (Map)ImmutableMap.of((Object)"Server Label", (Object)"Web Head 1", (Object)"Image Version", (Object)"2.1"));
    }

    public static Server parseServer() {
        Injector i = Guice.createInjector((Module[])new Module[]{new GsonModule()});
        InputStream is = ParseServerFromJsonResponseTest.class.getResourceAsStream("/test_get_server_detail.json");
        UnwrapOnlyJsonValue parser = (UnwrapOnlyJsonValue)i.getInstance(Key.get((TypeLiteral)new TypeLiteral<UnwrapOnlyJsonValue<Server>>(){}));
        Server response = (Server)parser.apply(((HttpResponse.Builder)HttpResponse.builder().statusCode(200).message("ok").payload(is)).build());
        return response;
    }
}

