/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudservers.handlers;

import org.jclouds.cloudservers.CloudServersClient;
import org.jclouds.cloudservers.internal.BaseCloudServersRestClientExpectTest;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.rest.AuthorizationException;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="RetryOnRenewExpectTest")
public class RetryOnRenewExpectTest
extends BaseCloudServersRestClientExpectTest {
    @Test
    public void testShouldReauthenticateOn401() {
        HttpRequest deleteImage = ((HttpRequest.Builder)HttpRequest.builder().method("DELETE").endpoint("https://lon.servers.api.rackspacecloud.com/v1.0/10001786/images/11?now=1257695648897").addHeader("X-Auth-Token", new String[]{this.authToken})).build();
        HttpResponse pleaseRenew = ((HttpResponse.Builder)HttpResponse.builder().statusCode(401).message("HTTP/1.1 401 Unauthorized").payload("[{\"unauthorized\":{\"message\":\"Invalid authentication token.  Please renew.\",\"code\":401}}]")).build();
        HttpRequest redoAuth = this.initialAuth;
        String authToken2 = "12345678-9012-47c0-9770-2c5097da25fc";
        HttpResponse responseWithUrls2 = ((HttpResponse.Builder)this.responseWithAuth.toBuilder().payload(this.responseWithAuth.getPayload().getRawContent().toString().replace(this.authToken, authToken2))).build();
        HttpRequest deleteImage2 = ((HttpRequest.Builder)HttpRequest.builder().method("DELETE").endpoint("https://lon.servers.api.rackspacecloud.com/v1.0/10001786/images/11?now=1257695648897").addHeader("X-Auth-Token", new String[]{authToken2})).build();
        HttpResponse imageDeleted = HttpResponse.builder().statusCode(204).message("HTTP/1.1 204 No Content").build();
        CloudServersClient clientWhenImageExists = (CloudServersClient)this.orderedRequestsSendResponses(this.initialAuth, this.responseWithAuth, deleteImage, pleaseRenew, redoAuth, responseWithUrls2, deleteImage2, imageDeleted);
        assert (clientWhenImageExists.deleteImage(11));
    }

    @Test(expectedExceptions={AuthorizationException.class})
    public void testDoesNotReauthenticateOnFatal401() {
        HttpRequest deleteImage = ((HttpRequest.Builder)HttpRequest.builder().method("DELETE").endpoint("https://lon.servers.api.rackspacecloud.com/v1.0/10001786/images/11?now=1257695648897").addHeader("X-Auth-Token", new String[]{this.authToken})).build();
        HttpResponse unauthResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(401).message("HTTP/1.1 401 Unauthorized").payload("[{\"unauthorized\":{\"message\":\"Fatal unauthorized.\",\"code\":401}}]")).build();
        CloudServersClient client = (CloudServersClient)this.orderedRequestsSendResponses(this.initialAuth, this.responseWithAuth, deleteImage, unauthResponse);
        client.deleteImage(11);
    }

    @Test(expectedExceptions={AuthorizationException.class})
    public void testDoesNotReauthenticateOnAuthentication401() {
        HttpResponse unauthResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(401).message("HTTP/1.1 401 Unauthorized").payload((Payload)Payloads.newStringPayload((String)"[{\"unauthorized\":{\"message\":\"A different message implying fatal.\",\"code\":401}}]"))).build();
        CloudServersClient client = (CloudServersClient)this.requestSendsResponse(this.initialAuth, unauthResponse);
        client.deleteImage(11);
    }
}

