/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudservers.functions;

import com.google.common.collect.ImmutableList;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import java.io.InputStream;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.List;
import org.jclouds.cloudservers.domain.SharedIpGroup;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.UnwrapOnlyJsonValue;
import org.jclouds.json.config.GsonModule;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class ParseSharedIpGroupListFromJsonResponseTest {
    Injector i = Guice.createInjector((Module[])new Module[]{new GsonModule()});

    public void testApplyInputStream() {
        InputStream is = this.getClass().getResourceAsStream("/test_list_sharedipgroups.json");
        ImmutableList expects = ImmutableList.of((Object)SharedIpGroup.builder().id(1234).name("Shared IP Group 1").build(), (Object)SharedIpGroup.builder().id(5678).name("Shared IP Group 2").build());
        UnwrapOnlyJsonValue parser = (UnwrapOnlyJsonValue)this.i.getInstance(Key.get((TypeLiteral)new TypeLiteral<UnwrapOnlyJsonValue<List<SharedIpGroup>>>(){}));
        List response = (List)parser.apply(((HttpResponse.Builder)HttpResponse.builder().statusCode(200).message("ok").payload(is)).build());
        Assert.assertEquals((Collection)response, (Collection)expects);
    }

    public void testApplyInputStreamDetails() throws UnknownHostException {
        InputStream is = this.getClass().getResourceAsStream("/test_list_sharedipgroups_detail.json");
        UnwrapOnlyJsonValue parser = (UnwrapOnlyJsonValue)this.i.getInstance(Key.get((TypeLiteral)new TypeLiteral<UnwrapOnlyJsonValue<List<SharedIpGroup>>>(){}));
        List response = (List)parser.apply(((HttpResponse.Builder)HttpResponse.builder().statusCode(200).message("ok").payload(is)).build());
        Assert.assertEquals((int)((SharedIpGroup)response.get(0)).getId(), (int)1234);
        Assert.assertEquals((String)((SharedIpGroup)response.get(0)).getName(), (String)"Shared IP Group 1");
        Assert.assertEquals((Collection)((SharedIpGroup)response.get(0)).getServers(), (Collection)ImmutableList.of((Object)422, (Object)3445));
        Assert.assertEquals((int)((SharedIpGroup)response.get(1)).getId(), (int)5678);
        Assert.assertEquals((String)((SharedIpGroup)response.get(1)).getName(), (String)"Shared IP Group 2");
        Assert.assertEquals((Collection)((SharedIpGroup)response.get(1)).getServers(), (Collection)ImmutableList.of((Object)23203, (Object)2456, (Object)9891));
    }
}

