/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudservers.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import org.jclouds.cloudservers.domain.VersionStatus;
import org.jclouds.javax.annotation.Nullable;

public class Version {
    private final String docURL;
    private final String id;
    private final VersionStatus status;
    private final String wadl;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromVersion(this);
    }

    @ConstructorProperties(value={"docURL", "id", "status", "wadl"})
    protected Version(String docURL, String id, @Nullable VersionStatus status, @Nullable String wadl) {
        this.docURL = (String)Preconditions.checkNotNull((Object)docURL, (Object)"docURL");
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
        this.status = status == null ? VersionStatus.UNRECOGNIZED : status;
        this.wadl = wadl;
    }

    public String getDocURL() {
        return this.docURL;
    }

    public String getId() {
        return this.id;
    }

    public VersionStatus getStatus() {
        return this.status;
    }

    @Nullable
    public String getWadl() {
        return this.wadl;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.docURL, this.id, this.status, this.wadl});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Version that = (Version)Version.class.cast(obj);
        return Objects.equal((Object)this.docURL, (Object)that.docURL) && Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)((Object)this.status), (Object)((Object)that.status)) && Objects.equal((Object)this.wadl, (Object)that.wadl);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).add("docURL", (Object)this.docURL).add("id", (Object)this.id).add("status", (Object)this.status).add("wadl", (Object)this.wadl);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String docURL;
        protected String id;
        protected VersionStatus status;
        protected String wadl;

        protected abstract T self();

        public T docURL(String docURL) {
            this.docURL = docURL;
            return this.self();
        }

        public T id(String id) {
            this.id = id;
            return this.self();
        }

        public T status(VersionStatus status) {
            this.status = status;
            return this.self();
        }

        public T wadl(String wadl) {
            this.wadl = wadl;
            return this.self();
        }

        public Version build() {
            return new Version(this.docURL, this.id, this.status, this.wadl);
        }

        public T fromVersion(Version in) {
            return ((Builder)((Builder)((Builder)this.docURL(in.getDocURL())).id(in.getId())).status(in.getStatus())).wadl(in.getWadl());
        }
    }
}

