/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudservers.functions;

import com.google.common.collect.ImmutableList;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import java.io.InputStream;
import java.net.UnknownHostException;
import java.util.Collection;
import org.jclouds.cloudservers.domain.SharedIpGroup;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.UnwrapOnlyJsonValue;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.json.config.GsonModule;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class ParseSharedIpGroupFromJsonResponseTest {
    Injector i = Guice.createInjector((Module[])new Module[]{new GsonModule()});

    public void testApplyInputStreamDetails() throws UnknownHostException {
        InputStream is = this.getClass().getResourceAsStream("/test_get_sharedipgroup_details.json");
        UnwrapOnlyJsonValue parser = (UnwrapOnlyJsonValue)this.i.getInstance(Key.get((TypeLiteral)new TypeLiteral<UnwrapOnlyJsonValue<SharedIpGroup>>(){}));
        SharedIpGroup response = (SharedIpGroup)parser.apply(new HttpResponse(200, "ok", (Payload)Payloads.newInputStreamPayload((InputStream)is)));
        Assert.assertEquals((int)response.getId(), (int)1234);
        Assert.assertEquals((String)response.getName(), (String)"Shared IP Group 1");
        Assert.assertEquals((Collection)response.getServers(), (Collection)ImmutableList.of((Object)422));
    }
}

