/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudservers.options;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.net.URI;
import java.util.Map;
import org.jclouds.cloudservers.options.CreateSharedIpGroupOptions;
import org.jclouds.http.HttpRequest;
import org.jclouds.json.config.GsonModule;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class CreateSharedIpGroupOptionsTest {
    Injector injector = Guice.createInjector((Module[])new Module[]{new GsonModule()});

    @Test
    public void testAddPayloadToRequestMapOfStringStringHttpRequest() {
        CreateSharedIpGroupOptions options = new CreateSharedIpGroupOptions();
        HttpRequest request = this.buildRequest(options);
        Assert.assertEquals((Object)"{\"sharedIpGroup\":{\"name\":\"foo\"}}", (Object)request.getPayload().getRawContent());
    }

    private HttpRequest buildRequest(CreateSharedIpGroupOptions options) {
        this.injector.injectMembers((Object)options);
        HttpRequest request = new HttpRequest("POST", URI.create("http://localhost"));
        options.bindToRequest(request, (Map)ImmutableMap.of((Object)"name", (Object)"foo"));
        return request;
    }

    @Test
    public void testWithServer() {
        CreateSharedIpGroupOptions options = new CreateSharedIpGroupOptions();
        options.withServer(3);
        HttpRequest request = this.buildRequest(options);
        this.assertSharedIpGroup(request);
    }

    @Test
    public void testWithServerStatic() {
        CreateSharedIpGroupOptions options = CreateSharedIpGroupOptions.Builder.withServer((int)3);
        HttpRequest request = this.buildRequest(options);
        this.assertSharedIpGroup(request);
    }

    private void assertSharedIpGroup(HttpRequest request) {
        Assert.assertEquals((Object)"{\"sharedIpGroup\":{\"name\":\"foo\",\"server\":3}}", (Object)request.getPayload().getRawContent());
    }
}

