/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudservers.internal;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.inject.Module;
import java.util.Date;
import java.util.Properties;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.cloudservers.CloudServersApiMetadata;
import org.jclouds.cloudservers.config.CloudServersRestClientModule;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.date.internal.SimpleDateFormatDateService;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.openstack.keystone.v1_1.config.AuthenticationServiceModule;
import org.jclouds.openstack.keystone.v1_1.internal.BaseKeystoneRestClientExpectTest;
import org.jclouds.rest.ConfiguresRestClient;

public abstract class BaseCloudServersComputeServiceExpectTest<T>
extends BaseKeystoneRestClientExpectTest<T>
implements Function<ComputeServiceContext, T> {
    protected static final String CONSTANT_DATE = "2009-11-08T15:54:08.897Z";

    public BaseCloudServersComputeServiceExpectTest() {
        this.provider = "cloudservers";
    }

    protected Module createModule() {
        return new TestCloudServersRestClientModule();
    }

    protected ApiMetadata createApiMetadata() {
        return new CloudServersApiMetadata();
    }

    protected Properties setupProperties() {
        Properties overrides = new Properties();
        overrides.setProperty("jclouds.regions", "US");
        overrides.setProperty(this.provider + ".endpoint", this.endpoint);
        return overrides;
    }

    public T createClient(Function<HttpRequest, HttpResponse> fn, Module module, Properties props) {
        return (T)this.apply(this.createComputeServiceContext(fn, module, props));
    }

    private ComputeServiceContext createComputeServiceContext(Function<HttpRequest, HttpResponse> fn, Module module, Properties props) {
        return (ComputeServiceContext)this.createInjector(fn, module, props).getInstance(ComputeServiceContext.class);
    }

    @ConfiguresRestClient
    protected static class TestCloudServersRestClientModule
    extends CloudServersRestClientModule {
        protected TestCloudServersRestClientModule() {
        }

        public Supplier<Date> provideCacheBusterDate() {
            return new Supplier<Date>(){

                public Date get() {
                    return new SimpleDateFormatDateService().iso8601DateParse(BaseCloudServersComputeServiceExpectTest.CONSTANT_DATE);
                }
            };
        }
    }

    public static class TestAuthenticationServiceModule
    extends AuthenticationServiceModule {
        protected void configure() {
            super.configure();
        }
    }
}

