/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudservers.compute.predicates;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.inject.Injector;
import java.net.URI;
import java.util.Map;
import org.jclouds.cloudservers.compute.predicates.GetImageWhenStatusActivePredicateWithResult;
import org.jclouds.cloudservers.internal.BaseCloudServersComputeServiceExpectTest;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.domain.Image;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.predicates.PredicateWithResult;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="GetImageWhenStatusActivePredicateWithResultExpectTest")
public class GetImageWhenStatusActivePredicateWithResultExpectTest
extends BaseCloudServersComputeServiceExpectTest<Injector> {
    private final HttpRequest listImagesDetail;
    private final HttpResponse listImagesResponse;
    private final Map<HttpRequest, HttpResponse> requestResponseMap;

    public GetImageWhenStatusActivePredicateWithResultExpectTest() {
        this.listImagesDetail = HttpRequest.builder().method("GET").endpoint(URI.create("https://lon.servers.api.rackspacecloud.com/v1.0/10001786/images/detail?format=json&now=1257695648897")).headers((Multimap)ImmutableMultimap.builder().put((Object)"Accept", (Object)"application/json").put((Object)"X-Auth-Token", (Object)this.authToken).build()).build();
        this.listImagesResponse = HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/test_list_images_detail_imageextension.json")).build();
        this.requestResponseMap = ImmutableMap.builder().put((Object)this.listImagesDetail, (Object)this.listImagesResponse).put((Object)this.initialAuth, (Object)this.responseWithAuth).build();
    }

    public void testReturnsFalseOnQueuedAndSavingAndTrueOnActive() {
        Injector injector = (Injector)this.requestsSendResponses(this.requestResponseMap);
        PredicateWithResult predicate = (PredicateWithResult)injector.getInstance(GetImageWhenStatusActivePredicateWithResult.class);
        Assert.assertTrue((boolean)predicate.apply((Object)2));
        Assert.assertFalse((boolean)predicate.apply((Object)743));
        Assert.assertFalse((boolean)predicate.apply((Object)744));
        Assert.assertFalse((boolean)predicate.apply((Object)747));
    }

    public void testFailsOnOtherStatuses() {
        Injector injector = (Injector)this.requestsSendResponses(this.requestResponseMap);
        PredicateWithResult predicate = (PredicateWithResult)injector.getInstance(GetImageWhenStatusActivePredicateWithResult.class);
        Assert.assertTrue((boolean)this.illegalStateExceptionThrown((PredicateWithResult<Integer, Image>)predicate, 745));
        Assert.assertTrue((boolean)this.illegalStateExceptionThrown((PredicateWithResult<Integer, Image>)predicate, 746));
        Assert.assertTrue((boolean)this.illegalStateExceptionThrown((PredicateWithResult<Integer, Image>)predicate, 748));
    }

    private boolean illegalStateExceptionThrown(PredicateWithResult<Integer, Image> predicate, Integer id) {
        try {
            predicate.apply((Object)id);
        }
        catch (IllegalStateException e) {
            return true;
        }
        return false;
    }

    public Injector apply(ComputeServiceContext input) {
        return input.utils().injector();
    }
}

