/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudservers.compute.functions;

import com.google.common.base.Function;
import com.google.inject.Guice;
import com.google.inject.Module;
import org.jclouds.cloudservers.compute.config.CloudServersComputeServiceContextModule;
import org.jclouds.cloudservers.compute.functions.CloudServersImageToImage;
import org.jclouds.cloudservers.compute.functions.CloudServersImageToOperatingSystem;
import org.jclouds.cloudservers.domain.Image;
import org.jclouds.cloudservers.functions.ParseImageFromJsonResponseTest;
import org.jclouds.compute.config.BaseComputeServiceContextModule;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.ImageBuilder;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.reference.ComputeServiceConstants;
import org.jclouds.json.Json;
import org.jclouds.json.config.GsonModule;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="CloudServersImageToImageTest")
public class CloudServersImageToImageTest {
    @Test
    public void test() {
        org.jclouds.compute.domain.Image toTest = CloudServersImageToImageTest.convertImage();
        Assert.assertEquals((Object)toTest, (Object)new ImageBuilder().name("CentOS 5.2").operatingSystem(new OperatingSystem.Builder().family(OsFamily.CENTOS).version("5.2").description("CentOS 5.2").is64Bit(true).build()).description("CentOS 5.2").ids("2").status(Image.Status.PENDING).version("1286712000000").build());
        Assert.assertEquals((Object)toTest.getStatus(), (Object)Image.Status.PENDING);
    }

    public static org.jclouds.compute.domain.Image convertImage() {
        Image image = ParseImageFromJsonResponseTest.parseImage();
        CloudServersImageToImage parser = new CloudServersImageToImage(CloudServersComputeServiceContextModule.toPortableImageStatus, (Function)new CloudServersImageToOperatingSystem(new BaseComputeServiceContextModule(){}.provideOsVersionMap(new ComputeServiceConstants.ReferenceData(), (Json)Guice.createInjector((Module[])new Module[]{new GsonModule()}).getInstance(Json.class))));
        return parser.apply(image);
    }
}

