/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudservers.functions;

import com.google.gson.Gson;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import java.io.InputStream;
import org.jclouds.cloudservers.domain.Flavor;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.UnwrapOnlyJsonValue;
import org.jclouds.json.config.GsonModule;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class ParseFlavorFromJsonResponseTest {
    public void test() {
        Flavor response = ParseFlavorFromJsonResponseTest.parseFlavor();
        String json = new Gson().toJson((Object)response);
        Assert.assertEquals((String)json, (String)"{\"id\":1,\"name\":\"256 MB Server\",\"disk\":10,\"ram\":256}");
    }

    public static Flavor parseFlavor() {
        Injector i = Guice.createInjector((Module[])new Module[]{new GsonModule()});
        InputStream is = ParseFlavorFromJsonResponseTest.class.getResourceAsStream("/test_get_flavor_details.json");
        UnwrapOnlyJsonValue parser = (UnwrapOnlyJsonValue)i.getInstance(Key.get((TypeLiteral)new TypeLiteral<UnwrapOnlyJsonValue<Flavor>>(){}));
        Flavor response = (Flavor)parser.apply(((HttpResponse.Builder)HttpResponse.builder().statusCode(200).message("ok").payload(is)).build());
        return response;
    }
}

