/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudservers;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.net.HostAndPort;
import com.google.inject.Injector;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.SecureRandom;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jclouds.cloudservers.CloudServersClient;
import org.jclouds.cloudservers.domain.BackupSchedule;
import org.jclouds.cloudservers.domain.DailyBackup;
import org.jclouds.cloudservers.domain.Flavor;
import org.jclouds.cloudservers.domain.Image;
import org.jclouds.cloudservers.domain.ImageStatus;
import org.jclouds.cloudservers.domain.Limits;
import org.jclouds.cloudservers.domain.RebootType;
import org.jclouds.cloudservers.domain.Server;
import org.jclouds.cloudservers.domain.ServerStatus;
import org.jclouds.cloudservers.domain.SharedIpGroup;
import org.jclouds.cloudservers.domain.WeeklyBackup;
import org.jclouds.cloudservers.options.CreateServerOptions;
import org.jclouds.cloudservers.options.CreateSharedIpGroupOptions;
import org.jclouds.cloudservers.options.ListOptions;
import org.jclouds.cloudservers.options.RebuildServerOptions;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.domain.ExecResponse;
import org.jclouds.compute.internal.BaseComputeServiceContextLiveTest;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.http.HttpResponseException;
import org.jclouds.io.Payload;
import org.jclouds.predicates.RetryablePredicate;
import org.jclouds.predicates.SocketOpen;
import org.jclouds.ssh.SshClient;
import org.jclouds.ssh.SshException;
import org.jclouds.util.Strings2;
import org.testng.Assert;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeGroups;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="CloudServersClientLiveTest")
public class CloudServersClientLiveTest
extends BaseComputeServiceContextLiveTest {
    protected CloudServersClient client;
    protected SshClient.Factory sshFactory;
    protected Predicate<HostAndPort> socketTester;
    private int sharedIpGroupId;
    private String serverPrefix = System.getProperty("user.name") + ".cs";
    private int serverId;
    private String adminPass;
    Map<String, String> metadata = ImmutableMap.of((Object)"jclouds", (Object)"rackspace");
    private String ip;
    private int serverId2;
    private String adminPass2;
    private int imageId;

    public CloudServersClientLiveTest() {
        this.provider = "cloudservers";
    }

    @BeforeGroups(groups={"integration", "live"})
    public void setupContext() {
        super.setupContext();
        Injector injector = ((ComputeServiceContext)this.view).utils().injector();
        this.client = (CloudServersClient)injector.getInstance(CloudServersClient.class);
        this.sshFactory = (SshClient.Factory)injector.getInstance(SshClient.Factory.class);
        SocketOpen socketOpen = (SocketOpen)injector.getInstance(SocketOpen.class);
        this.socketTester = new RetryablePredicate((Predicate)socketOpen, 120L, 1L, TimeUnit.SECONDS);
        injector.injectMembers((Object)socketOpen);
    }

    public void testLimits() throws Exception {
        Limits response = this.client.getLimits();
        assert (null != response);
        Assert.assertTrue((response.getAbsolute().size() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((response.getRate().size() > 0 ? 1 : 0) != 0);
    }

    public void testListServers() throws Exception {
        Set response = this.client.listServers(new ListOptions[0]);
        assert (null != response);
        long initialContainerCount = response.size();
        Assert.assertTrue((initialContainerCount >= 0L ? 1 : 0) != 0);
    }

    public void testListServersDetail() throws Exception {
        Set response = this.client.listServers(new ListOptions[]{ListOptions.Builder.withDetails()});
        assert (null != response);
        long initialContainerCount = response.size();
        Assert.assertTrue((initialContainerCount >= 0L ? 1 : 0) != 0);
    }

    public void testListImages() throws Exception {
        Set response = this.client.listImages(new ListOptions[0]);
        assert (null != response);
        long imageCount = response.size();
        Assert.assertTrue((imageCount >= 1L ? 1 : 0) != 0);
        for (Image image : response) {
            Assert.assertTrue((image.getId() >= 0 ? 1 : 0) != 0);
            assert (null != image.getName()) : image;
        }
    }

    public void testListImagesDetail() throws Exception {
        Set response = this.client.listImages(new ListOptions[]{ListOptions.Builder.withDetails()});
        assert (null != response);
        long imageCount = response.size();
        Assert.assertTrue((imageCount >= 0L ? 1 : 0) != 0);
        for (Image image : response) {
            Assert.assertTrue((image.getId() >= 1 ? 1 : 0) != 0);
            assert (null != image.getName()) : image;
            assert (null != image.getStatus()) : image;
        }
    }

    public void testGetImagesDetail() throws Exception {
        Set response = this.client.listImages(new ListOptions[]{ListOptions.Builder.withDetails()});
        assert (null != response);
        long imageCount = response.size();
        Assert.assertTrue((imageCount >= 0L ? 1 : 0) != 0);
        for (Image image : response) {
            Image newDetails = this.client.getImage(image.getId());
            Assert.assertEquals((Object)image, (Object)newDetails);
        }
    }

    @Test
    public void testGetImageDetailsNotFound() throws Exception {
        assert (this.client.getImage(12312987) == null);
    }

    @Test
    public void testGetServerDetailsNotFound() throws Exception {
        assert (this.client.getServer(12312987) == null);
    }

    public void testGetServersDetail() throws Exception {
        Set response = this.client.listServers(new ListOptions[]{ListOptions.Builder.withDetails()});
        assert (null != response);
        long serverCount = response.size();
        Assert.assertTrue((serverCount >= 0L ? 1 : 0) != 0);
        for (Server server : response) {
            Server newDetails = this.client.getServer(server.getId());
            Assert.assertEquals((Object)server, (Object)newDetails);
        }
    }

    public void testListFlavors() throws Exception {
        Set response = this.client.listFlavors(new ListOptions[0]);
        assert (null != response);
        long flavorCount = response.size();
        Assert.assertTrue((flavorCount >= 1L ? 1 : 0) != 0);
        for (Flavor flavor : response) {
            Assert.assertTrue((flavor.getId() >= 0 ? 1 : 0) != 0);
            assert (null != flavor.getName()) : flavor;
        }
    }

    public void testListFlavorsDetail() throws Exception {
        Set response = this.client.listFlavors(new ListOptions[]{ListOptions.Builder.withDetails()});
        assert (null != response);
        long flavorCount = response.size();
        Assert.assertTrue((flavorCount >= 0L ? 1 : 0) != 0);
        for (Flavor flavor : response) {
            Assert.assertTrue((flavor.getId() >= 1 ? 1 : 0) != 0);
            assert (null != flavor.getName()) : flavor;
            assert (null != flavor.getDisk()) : flavor;
            assert (null != flavor.getRam()) : flavor;
        }
    }

    public void testGetFlavorsDetail() throws Exception {
        Set response = this.client.listFlavors(new ListOptions[]{ListOptions.Builder.withDetails()});
        assert (null != response);
        long flavorCount = response.size();
        Assert.assertTrue((flavorCount >= 0L ? 1 : 0) != 0);
        for (Flavor flavor : response) {
            Flavor newDetails = this.client.getFlavor(flavor.getId());
            Assert.assertEquals((Object)flavor, (Object)newDetails);
        }
    }

    @Test
    public void testGetFlavorDetailsNotFound() throws Exception {
        assert (this.client.getFlavor(12312987) == null);
    }

    public void testListSharedIpGroups() throws Exception {
        Set response = this.client.listSharedIpGroups(new ListOptions[0]);
        assert (null != response);
        long sharedIpGroupCount = response.size();
        Assert.assertTrue((sharedIpGroupCount >= 0L ? 1 : 0) != 0);
        for (SharedIpGroup sharedIpGroup : response) {
            Assert.assertTrue((sharedIpGroup.getId() >= 0 ? 1 : 0) != 0);
            assert (null != sharedIpGroup.getName()) : sharedIpGroup;
        }
    }

    public void testListSharedIpGroupsDetail() throws Exception {
        Set response = this.client.listSharedIpGroups(new ListOptions[]{ListOptions.Builder.withDetails()});
        assert (null != response);
        long sharedIpGroupCount = response.size();
        Assert.assertTrue((sharedIpGroupCount >= 0L ? 1 : 0) != 0);
        for (SharedIpGroup sharedIpGroup : response) {
            Assert.assertTrue((sharedIpGroup.getId() >= 1 ? 1 : 0) != 0);
            assert (null != sharedIpGroup.getName()) : sharedIpGroup;
            assert (null != sharedIpGroup.getServers()) : sharedIpGroup;
        }
    }

    public void testGetSharedIpGroupsDetail() throws Exception {
        Set response = this.client.listSharedIpGroups(new ListOptions[]{ListOptions.Builder.withDetails()});
        assert (null != response);
        long sharedIpGroupCount = response.size();
        Assert.assertTrue((sharedIpGroupCount >= 0L ? 1 : 0) != 0);
        for (SharedIpGroup sharedIpGroup : response) {
            SharedIpGroup newDetails = this.client.getSharedIpGroup(sharedIpGroup.getId());
            Assert.assertEquals((Object)sharedIpGroup, (Object)newDetails);
        }
    }

    @Test
    public void testGetSharedIpGroupDetailsNotFound() throws Exception {
        assert (this.client.getSharedIpGroup(12312987) == null);
    }

    @Test(timeOut=300000L, dependsOnMethods={"testCreateServer"})
    public void testCreateSharedIpGroup() throws Exception {
        SharedIpGroup sharedIpGroup = null;
        while (sharedIpGroup == null) {
            String sharedIpGroupName = this.serverPrefix + "createSharedIpGroup" + new SecureRandom().nextInt();
            try {
                sharedIpGroup = this.client.createSharedIpGroup(sharedIpGroupName, new CreateSharedIpGroupOptions[]{CreateSharedIpGroupOptions.Builder.withServer((int)this.serverId)});
            }
            catch (UndeclaredThrowableException e) {
                HttpResponseException htpe = (HttpResponseException)e.getCause().getCause();
                if (htpe.getResponse().getStatusCode() == 400) continue;
                throw e;
            }
        }
        Assert.assertNotNull((Object)sharedIpGroup.getName());
        this.sharedIpGroupId = sharedIpGroup.getId();
        assert (!((Object)sharedIpGroup.getServers()).equals(ImmutableList.of((Object)this.serverId)));
    }

    public void testCreateServer() throws Exception {
        int imageId = 14362;
        int flavorId = 1;
        Server server = null;
        while (server == null) {
            String serverName = this.serverPrefix + "createserver" + new SecureRandom().nextInt();
            try {
                server = this.client.createServer(serverName, imageId, flavorId, new CreateServerOptions[]{CreateServerOptions.Builder.withFile((String)"/etc/jclouds.txt", (byte[])"rackspace".getBytes()).withMetadata(this.metadata)});
            }
            catch (UndeclaredThrowableException e) {
                HttpResponseException htpe = (HttpResponseException)e.getCause().getCause();
                if (htpe.getResponse().getStatusCode() == 400) continue;
                throw e;
            }
        }
        Assert.assertNotNull((Object)server.getAdminPass());
        this.serverId = server.getId();
        this.adminPass = server.getAdminPass();
        this.ip = (String)server.getAddresses().getPublicAddresses().iterator().next();
        Assert.assertEquals((Object)server.getStatus(), (Object)ServerStatus.BUILD);
        this.blockUntilServerActive(this.serverId);
    }

    private void blockUntilServerActive(int serverId) throws InterruptedException {
        Server currentDetails = null;
        currentDetails = this.client.getServer(serverId);
        while (currentDetails.getStatus() != ServerStatus.ACTIVE) {
            System.out.printf("blocking on status active%n%s%n", currentDetails);
            Thread.sleep(5000L);
            currentDetails = this.client.getServer(serverId);
        }
    }

    private void blockUntilServerVerifyResize(int serverId) throws InterruptedException {
        Server currentDetails = null;
        currentDetails = this.client.getServer(serverId);
        while (currentDetails.getStatus() != ServerStatus.VERIFY_RESIZE) {
            System.out.printf("blocking on status verify resize%n%s%n", currentDetails);
            Thread.sleep(5000L);
            currentDetails = this.client.getServer(serverId);
        }
    }

    private void blockUntilImageActive(int imageId) throws InterruptedException {
        Image currentDetails = null;
        currentDetails = this.client.getImage(imageId);
        while (currentDetails.getStatus() != ImageStatus.ACTIVE) {
            System.out.printf("blocking on status active%n%s%n", currentDetails);
            Thread.sleep(5000L);
            currentDetails = this.client.getImage(imageId);
        }
    }

    @Test(timeOut=300000L, dependsOnMethods={"testCreateServer"})
    public void testServerDetails() throws Exception {
        Server server = this.client.getServer(this.serverId);
        Assert.assertNotNull((Object)server.getHostId());
        Assert.assertEquals((Object)server.getStatus(), (Object)ServerStatus.ACTIVE);
        assert (server.getProgress() >= 0) : "newDetails.getProgress()" + server.getProgress();
        Assert.assertEquals((Object)new Integer(14362), (Object)server.getImageId());
        Assert.assertEquals((Object)new Integer(1), (Object)server.getFlavorId());
        Assert.assertNotNull((Object)server.getAddresses());
        Assert.assertEquals((Object)this.client.getAddresses(this.serverId), (Object)server.getAddresses());
        Assert.assertEquals((int)server.getAddresses().getPublicAddresses().size(), (int)1);
        Assert.assertEquals((Set)this.client.listPublicAddresses(this.serverId), (Set)server.getAddresses().getPublicAddresses());
        Assert.assertEquals((int)server.getAddresses().getPrivateAddresses().size(), (int)1);
        Assert.assertEquals((Set)this.client.listPrivateAddresses(this.serverId), (Set)server.getAddresses().getPrivateAddresses());
        Assert.assertEquals((Map)server.getMetadata(), this.metadata);
        this.checkPassOk(server, this.adminPass);
    }

    private void checkPassOk(Server newDetails, String pass) throws IOException {
        try {
            this.doCheckPass(newDetails, pass);
        }
        catch (SshException e) {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e1) {
                // empty catch block
            }
            this.doCheckPass(newDetails, pass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCheckPass(Server newDetails, String pass) throws IOException {
        HostAndPort socket = HostAndPort.fromParts((String)((String)Iterables.get((Iterable)newDetails.getAddresses().getPublicAddresses(), (int)0)), (int)22);
        this.socketTester.apply((Object)socket);
        SshClient client = this.sshFactory.create(socket, LoginCredentials.builder().user("root").password(pass).build());
        try {
            client.connect();
            Payload etcPasswd = client.get("/etc/jclouds.txt");
            String etcPasswdContents = Strings2.toStringAndClose((InputStream)etcPasswd.getInput());
            Assert.assertEquals((String)"rackspace", (String)etcPasswdContents.trim());
        }
        finally {
            if (client != null) {
                client.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExecResponse exec(Server details, String pass, String command) throws IOException {
        HostAndPort socket = HostAndPort.fromParts((String)((String)Iterables.get((Iterable)details.getAddresses().getPublicAddresses(), (int)0)), (int)22);
        this.socketTester.apply((Object)socket);
        SshClient client = this.sshFactory.create(socket, LoginCredentials.builder().user("root").password(pass).build());
        try {
            client.connect();
            ExecResponse execResponse = client.exec(command);
            return execResponse;
        }
        finally {
            if (client != null) {
                client.disconnect();
            }
        }
    }

    @Test(timeOut=300000L, dependsOnMethods={"testCreateServer"})
    public void testRenameServer() throws Exception {
        Server server = this.client.getServer(this.serverId);
        String oldName = server.getName();
        this.client.renameServer(this.serverId, oldName + "new");
        this.blockUntilServerActive(this.serverId);
        Assert.assertEquals((String)(oldName + "new"), (String)this.client.getServer(this.serverId).getName());
    }

    @Test(timeOut=300000L, dependsOnMethods={"testCreateServer"})
    public void testChangePassword() throws Exception {
        this.client.changeAdminPass(this.serverId, "elmo");
        this.blockUntilServerActive(this.serverId);
        this.checkPassOk(this.client.getServer(this.serverId), "elmo");
        this.adminPass = "elmo";
    }

    @Test(timeOut=300000L, dependsOnMethods={"testCreateSharedIpGroup"})
    public void testCreateServerIp() throws Exception {
        int imageId = 14362;
        int flavorId = 1;
        Server server = null;
        while (server == null) {
            String serverName = this.serverPrefix + "createserver" + new SecureRandom().nextInt();
            try {
                server = this.client.createServer(serverName, imageId, flavorId, new CreateServerOptions[]{CreateServerOptions.Builder.withFile((String)"/etc/jclouds.txt", (byte[])"rackspace".getBytes()).withMetadata(this.metadata).withSharedIpGroup(this.sharedIpGroupId).withSharedIp(this.ip)});
            }
            catch (UndeclaredThrowableException e) {
                HttpResponseException htpe = (HttpResponseException)e.getCause().getCause();
                if (htpe.getResponse().getStatusCode() == 400) continue;
                throw e;
            }
        }
        Assert.assertNotNull((Object)server.getAdminPass());
        this.serverId2 = server.getId();
        this.adminPass2 = server.getAdminPass();
        this.blockUntilServerActive(this.serverId2);
        this.assertIpConfigured(server, this.adminPass2);
        assert (server.getAddresses().getPublicAddresses().contains(this.ip)) : server.getAddresses() + " doesn't contain " + this.ip;
        Assert.assertEquals((Object)server.getSharedIpGroupId(), (Object)new Integer(this.sharedIpGroupId));
    }

    private void assertIpConfigured(Server server, String password) {
        try {
            ExecResponse response = this.exec(server, password, "ifconfig -a");
            assert (response.getOutput().indexOf(this.ip) > 0) : String.format("server %s didn't get ip %s%n%s", server, this.ip, response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        catch (AssertionError e) {
            ((Throwable)((Object)e)).printStackTrace();
        }
    }

    @Test(timeOut=600000L, dependsOnMethods={"testCreateServerIp"})
    public void testUnshare() throws Exception {
        this.client.unshareIp(this.ip, this.serverId2);
        this.blockUntilServerActive(this.serverId2);
        Server server = this.client.getServer(this.serverId2);
        assert (!server.getAddresses().getPublicAddresses().contains(this.ip)) : server.getAddresses();
        this.assertIpNotConfigured(server, this.adminPass2);
    }

    private void assertIpNotConfigured(Server server, String password) {
        try {
            ExecResponse response = this.exec(server, password, "ifconfig -a");
            assert (response.getOutput().indexOf(this.ip) == -1) : String.format("server %s still has get ip %s%n%s", server, this.ip, response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        catch (AssertionError e) {
            ((Throwable)((Object)e)).printStackTrace();
        }
    }

    @Test(timeOut=600000L, dependsOnMethods={"testUnshare"})
    public void testShareConfig() throws Exception {
        this.client.shareIp(this.ip, this.serverId2, this.sharedIpGroupId, true);
        this.blockUntilServerActive(this.serverId2);
        Server server = this.client.getServer(this.serverId2);
        assert (server.getAddresses().getPublicAddresses().contains(this.ip)) : server.getAddresses();
        this.assertIpConfigured(server, this.adminPass2);
        this.testUnshare();
    }

    @Test(timeOut=600000L, dependsOnMethods={"testShareConfig"})
    public void testShareNoConfig() throws Exception {
        this.client.shareIp(this.ip, this.serverId2, this.sharedIpGroupId, false);
        this.blockUntilServerActive(this.serverId2);
        Server server = this.client.getServer(this.serverId2);
        assert (server.getAddresses().getPublicAddresses().contains(this.ip)) : server.getAddresses();
        this.assertIpNotConfigured(server, this.adminPass2);
        this.testUnshare();
    }

    @Test(timeOut=600000L, dependsOnMethods={"testShareNoConfig"})
    public void testBackup() throws Exception {
        Assert.assertEquals((Object)new BackupSchedule(), (Object)this.client.getBackupSchedule(this.serverId));
        BackupSchedule dailyWeekly = new BackupSchedule();
        dailyWeekly.setEnabled(true);
        dailyWeekly.setWeekly(WeeklyBackup.FRIDAY);
        dailyWeekly.setDaily(DailyBackup.H_0400_0600);
        this.client.replaceBackupSchedule(this.serverId, dailyWeekly);
        this.client.deleteBackupSchedule(this.serverId);
        Assert.assertEquals((boolean)this.client.getBackupSchedule(this.serverId).isEnabled(), (boolean)false);
    }

    @Test(timeOut=600000L, dependsOnMethods={"testBackup"})
    public void testCreateImage() throws Exception {
        Image image = this.client.createImageFromServer("hoofie", this.serverId);
        Assert.assertEquals((String)"hoofie", (String)image.getName());
        Assert.assertEquals((Object)new Integer(this.serverId), (Object)image.getServerId());
        this.imageId = image.getId();
        this.blockUntilImageActive(this.imageId);
    }

    @Test(timeOut=600000L, dependsOnMethods={"testCreateImage"})
    public void testRebuildServer() throws Exception {
        this.client.rebuildServer(this.serverId, new RebuildServerOptions[]{new RebuildServerOptions().withImage(this.imageId)});
        this.blockUntilServerActive(this.serverId);
        assert (!new Integer(this.imageId).equals(this.client.getServer(this.serverId).getImageId()));
    }

    @Test(timeOut=600000L, dependsOnMethods={"testRebuildServer"})
    public void testRebootHard() throws Exception {
        this.client.rebootServer(this.serverId, RebootType.HARD);
        this.blockUntilServerActive(this.serverId);
    }

    @Test(timeOut=600000L, dependsOnMethods={"testRebootHard"})
    public void testRebootSoft() throws Exception {
        this.client.rebootServer(this.serverId, RebootType.SOFT);
        this.blockUntilServerActive(this.serverId);
    }

    @Test(timeOut=600000L, dependsOnMethods={"testRebootSoft"})
    public void testRevertResize() throws Exception {
        this.client.resizeServer(this.serverId, 2);
        this.blockUntilServerVerifyResize(this.serverId);
        this.client.revertResizeServer(this.serverId);
        this.blockUntilServerActive(this.serverId);
        Assert.assertEquals((Object)new Integer(1), (Object)this.client.getServer(this.serverId).getFlavorId());
    }

    @Test(timeOut=600000L, dependsOnMethods={"testRebootSoft"})
    public void testConfirmResize() throws Exception {
        this.client.resizeServer(this.serverId2, 2);
        this.blockUntilServerVerifyResize(this.serverId2);
        this.client.confirmResizeServer(this.serverId2);
        this.blockUntilServerActive(this.serverId2);
        Assert.assertEquals((Object)new Integer(2), (Object)this.client.getServer(this.serverId2).getFlavorId());
    }

    @Test(timeOut=600000L, dependsOnMethods={"testRebootSoft", "testRevertResize", "testConfirmResize"})
    void deleteServer2() {
        if (this.serverId2 > 0) {
            this.client.deleteServer(this.serverId2);
            assert (this.client.getServer(this.serverId2) == null);
        }
    }

    @Test(timeOut=600000L, dependsOnMethods={"deleteServer2"})
    void testDeleteImage() {
        if (this.imageId > 0) {
            this.client.deleteImage(this.imageId);
            assert (this.client.getImage(this.imageId) == null);
        }
    }

    @Test(timeOut=600000L, dependsOnMethods={"testDeleteImage"})
    void deleteServer1() {
        if (this.serverId > 0) {
            this.client.deleteServer(this.serverId);
            assert (this.client.getServer(this.serverId) == null);
        }
    }

    @Test(timeOut=600000L, dependsOnMethods={"deleteServer1"})
    void testDeleteSharedIpGroup() {
        if (this.sharedIpGroupId > 0) {
            this.client.deleteSharedIpGroup(this.sharedIpGroupId);
            assert (this.client.getSharedIpGroup(this.sharedIpGroupId) == null);
        }
    }

    @AfterTest
    void deleteServersOnEnd() {
        if (this.serverId > 0) {
            this.client.deleteServer(this.serverId);
        }
        if (this.serverId2 > 0) {
            this.client.deleteServer(this.serverId2);
        }
        if (this.sharedIpGroupId > 0) {
            this.client.deleteSharedIpGroup(this.sharedIpGroupId);
        }
    }
}

