/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudservers.internal;

import com.google.common.base.Supplier;
import com.google.inject.Module;
import java.util.Date;
import java.util.Properties;
import org.jclouds.cloudservers.CloudServersClient;
import org.jclouds.cloudservers.CloudServersContextBuilder;
import org.jclouds.cloudservers.CloudServersPropertiesBuilder;
import org.jclouds.cloudservers.config.CloudServersRestClientModule;
import org.jclouds.date.internal.SimpleDateFormatDateService;
import org.jclouds.http.RequiresHttp;
import org.jclouds.openstack.keystone.v1_1.config.AuthenticationServiceModule;
import org.jclouds.openstack.keystone.v1_1.internal.BaseKeystoneRestClientExpectTest;
import org.jclouds.rest.ConfiguresRestClient;

public class BaseCloudServersRestClientExpectTest
extends BaseKeystoneRestClientExpectTest<CloudServersClient> {
    protected static final String CONSTANT_DATE = "2009-11-08T15:54:08.897Z";

    public BaseCloudServersRestClientExpectTest() {
        this.provider = "cloudservers";
    }

    protected Properties setupRestProperties() {
        Properties overrides = new Properties();
        overrides.setProperty("jclouds.regions", "US");
        overrides.setProperty(this.provider + ".endpoint", this.endpoint);
        overrides.setProperty(this.provider + ".contextbuilder", CloudServersContextBuilder.class.getName());
        overrides.setProperty(this.provider + ".propertiesbuilder", CloudServersPropertiesBuilder.class.getName());
        return overrides;
    }

    protected Module createModule() {
        return new TestCloudServersRestClientModule();
    }

    @ConfiguresRestClient
    @RequiresHttp
    protected static class TestCloudServersRestClientModule
    extends CloudServersRestClientModule {
        protected TestCloudServersRestClientModule() {
        }

        public Supplier<Date> provideCacheBusterDate() {
            return new Supplier<Date>(){

                public Date get() {
                    return new SimpleDateFormatDateService().iso8601DateParse(BaseCloudServersRestClientExpectTest.CONSTANT_DATE);
                }
            };
        }
    }

    public static class TestAuthenticationServiceModule
    extends AuthenticationServiceModule {
        protected void configure() {
            super.configure();
        }
    }
}

