/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudservers.functions;

import com.google.common.collect.ImmutableList;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import java.io.InputStream;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.List;
import org.jclouds.cloudservers.domain.Image;
import org.jclouds.cloudservers.domain.ImageStatus;
import org.jclouds.date.DateService;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.UnwrapOnlyJsonValue;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.json.config.GsonModule;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class ParseImageListFromJsonResponseTest {
    Injector i = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

        protected void configure() {
            this.bind(GsonModule.DateAdapter.class).to(GsonModule.Iso8601DateAdapter.class);
        }
    }, new GsonModule()});
    DateService dateService = (DateService)this.i.getInstance(DateService.class);

    public void testApplyInputStream() {
        InputStream is = this.getClass().getResourceAsStream("/test_list_images.json");
        ImmutableList expects = ImmutableList.of((Object)new Image(2, "CentOS 5.2"), (Object)new Image(743, "My Server Backup"));
        UnwrapOnlyJsonValue parser = (UnwrapOnlyJsonValue)this.i.getInstance(Key.get((TypeLiteral)new TypeLiteral<UnwrapOnlyJsonValue<List<Image>>>(){}));
        List response = (List)parser.apply(new HttpResponse(200, "ok", (Payload)Payloads.newInputStreamPayload((InputStream)is)));
        Assert.assertEquals((Collection)response, (Collection)expects);
    }

    public void testApplyInputStreamDetails() throws UnknownHostException {
        InputStream is = this.getClass().getResourceAsStream("/test_list_images_detail.json");
        UnwrapOnlyJsonValue parser = (UnwrapOnlyJsonValue)this.i.getInstance(Key.get((TypeLiteral)new TypeLiteral<UnwrapOnlyJsonValue<List<Image>>>(){}));
        List response = (List)parser.apply(new HttpResponse(200, "ok", (Payload)Payloads.newInputStreamPayload((InputStream)is)));
        Assert.assertEquals((int)((Image)response.get(0)).getId(), (int)2);
        Assert.assertEquals((String)((Image)response.get(0)).getName(), (String)"CentOS 5.2");
        Assert.assertEquals((Object)((Image)response.get(0)).getCreated(), (Object)this.dateService.iso8601SecondsDateParse("2010-08-10T12:00:00Z"));
        Assert.assertEquals((Object)((Image)response.get(0)).getProgress(), null);
        Assert.assertEquals((Object)((Image)response.get(0)).getServerId(), null);
        Assert.assertEquals((Object)((Image)response.get(0)).getStatus(), (Object)ImageStatus.ACTIVE);
        Assert.assertEquals((Object)((Image)response.get(0)).getUpdated(), (Object)this.dateService.iso8601SecondsDateParse("2010-10-10T12:00:00Z"));
        Assert.assertEquals((int)((Image)response.get(1)).getId(), (int)743);
        Assert.assertEquals((String)((Image)response.get(1)).getName(), (String)"My Server Backup");
        Assert.assertEquals((Object)((Image)response.get(1)).getCreated(), (Object)this.dateService.iso8601SecondsDateParse("2009-07-07T09:56:16-05:00"));
        Assert.assertEquals((Object)((Image)response.get(1)).getProgress(), (Object)new Integer(80));
        Assert.assertEquals((Object)((Image)response.get(1)).getServerId(), (Object)new Integer(12));
        Assert.assertEquals((Object)((Image)response.get(1)).getStatus(), (Object)ImageStatus.SAVING);
        Assert.assertEquals((Object)((Image)response.get(1)).getUpdated(), (Object)this.dateService.iso8601SecondsDateParse("2010-10-10T12:00:00Z"));
    }
}

