/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudservers.compute.functions;

import com.google.common.base.Function;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.cloudservers.domain.Image;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.logging.Logger;

@Singleton
public class CloudServersImageToOperatingSystem
implements Function<Image, OperatingSystem> {
    public static final Pattern DEFAULT_PATTERN = Pattern.compile("(([^ ]*) ([0-9.]+) ?.*)");
    public static final Pattern WINDOWS_PATTERN = Pattern.compile("Windows (.*) (x[86][64])");
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final Map<OsFamily, Map<String, String>> osVersionMap;

    @Inject
    public CloudServersImageToOperatingSystem(Map<OsFamily, Map<String, String>> osVersionMap) {
        this.osVersionMap = osVersionMap;
    }

    public OperatingSystem apply(Image from) {
        OsFamily osFamily = null;
        String osName = null;
        String osArch = null;
        String osVersion = null;
        String osDescription = from.getName();
        boolean is64Bit = true;
        if (from.getName().indexOf("Red Hat EL") != -1) {
            osFamily = OsFamily.RHEL;
        } else if (from.getName().indexOf("Oracle EL") != -1) {
            osFamily = OsFamily.OEL;
        } else if (from.getName().indexOf("Windows") != -1) {
            osFamily = OsFamily.WINDOWS;
            Matcher matcher = WINDOWS_PATTERN.matcher(from.getName());
            if (matcher.find()) {
                osVersion = ComputeServiceUtils.parseVersionOrReturnEmptyString((OsFamily)osFamily, (String)matcher.group(1), this.osVersionMap);
                is64Bit = matcher.group(2).equals("x64");
            }
        } else {
            Matcher matcher = DEFAULT_PATTERN.matcher(from.getName());
            if (matcher.find()) {
                try {
                    osFamily = OsFamily.fromValue((String)matcher.group(2).toLowerCase());
                }
                catch (IllegalArgumentException e) {
                    this.logger.debug("<< didn't match os(%s)", new Object[]{matcher.group(2)});
                }
                osVersion = ComputeServiceUtils.parseVersionOrReturnEmptyString((OsFamily)osFamily, (String)matcher.group(3), this.osVersionMap);
            }
        }
        return new OperatingSystem(osFamily, osName, osVersion, osArch, osDescription, is64Bit);
    }
}

