/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudservers.handlers;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.net.URI;
import org.jclouds.cloudservers.CloudServersClient;
import org.jclouds.cloudservers.internal.BaseCloudServersRestClientExpectTest;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.rest.AuthorizationException;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="RetryOnRenewExpectTest")
public class RetryOnRenewExpectTest
extends BaseCloudServersRestClientExpectTest {
    @Test
    public void testShouldReauthenticateOn401() {
        String authToken = "d6245d35-22a0-47c0-9770-2c5097da25fc";
        String authToken2 = "12345678-9012-47c0-9770-2c5097da25fc";
        HttpRequest initialAuth = HttpRequest.builder().method("GET").endpoint(URI.create("https://auth/v1.0")).headers((Multimap)ImmutableMultimap.builder().put((Object)"X-Auth-User", (Object)"identity").put((Object)"X-Auth-Key", (Object)"credential").put((Object)"Accept", (Object)"*/*").build()).build();
        HttpResponse responseWithUrls = HttpResponse.builder().statusCode(204).message("HTTP/1.1 204 No Content").headers((Multimap)ImmutableMultimap.builder().put((Object)"Server", (Object)"Apache/2.2.3 (Red Hat)").put((Object)"vary", (Object)"X-Auth-Token,X-Auth-Key,X-Storage-User,X-Storage-Pass").put((Object)"X-Storage-Url", (Object)"https://storage101.dfw1.clouddrive.com/v1/MossoCloudFS_dc1f419c-5059-4c87-a389-3f2e33a77b22").put((Object)"Cache-Control", (Object)"s-maxage=86399").put((Object)"Content-Type", (Object)"text/xml").put((Object)"Date", (Object)"Tue, 10 Jan 2012 22:08:47 GMT").put((Object)"X-Auth-Token", (Object)authToken).put((Object)"X-Server-Management-Url", (Object)"https://servers.api.rackspacecloud.com/v1.0/413274").put((Object)"X-Storage-Token", (Object)authToken).put((Object)"Connection", (Object)"Keep-Alive").put((Object)"X-CDN-Management-Url", (Object)"https://cdn1.clouddrive.com/v1/MossoCloudFS_dc1f419c-5059-4c87-a389-3f2e33a77b22").put((Object)"Content-Length", (Object)"0").build()).build();
        HttpResponse responseWithUrls2 = HttpResponse.builder().statusCode(204).message("HTTP/1.1 204 No Content").headers((Multimap)ImmutableMultimap.builder().put((Object)"Server", (Object)"Apache/2.2.3 (Red Hat)").put((Object)"vary", (Object)"X-Auth-Token,X-Auth-Key,X-Storage-User,X-Storage-Pass").put((Object)"X-Storage-Url", (Object)"https://storage101.dfw1.clouddrive.com/v1/MossoCloudFS_dc1f419c-5059-4c87-a389-3f2e33a77b22").put((Object)"Cache-Control", (Object)"s-maxage=86399").put((Object)"Content-Type", (Object)"text/xml").put((Object)"Date", (Object)"Tue, 10 Jan 2012 22:08:47 GMT").put((Object)"X-Auth-Token", (Object)authToken2).put((Object)"X-Server-Management-Url", (Object)"https://servers.api.rackspacecloud.com/v1.0/413274").put((Object)"X-Storage-Token", (Object)authToken2).put((Object)"Connection", (Object)"Keep-Alive").put((Object)"X-CDN-Management-Url", (Object)"https://cdn1.clouddrive.com/v1/MossoCloudFS_dc1f419c-5059-4c87-a389-3f2e33a77b22").put((Object)"Content-Length", (Object)"0").build()).build();
        HttpRequest deleteImage = HttpRequest.builder().method("DELETE").endpoint(URI.create("https://servers.api.rackspacecloud.com/v1.0/413274/images/11?now=1257695648897")).headers((Multimap)ImmutableMultimap.builder().put((Object)"X-Auth-Token", (Object)authToken).build()).build();
        HttpResponse pleaseRenew = HttpResponse.builder().statusCode(401).message("HTTP/1.1 401 Unauthorized").payload((Payload)Payloads.newStringPayload((String)"[{\"unauthorized\":{\"message\":\"Invalid authentication token.  Please renew.\",\"code\":401}}]")).build();
        HttpRequest deleteImage2 = HttpRequest.builder().method("DELETE").endpoint(URI.create("https://servers.api.rackspacecloud.com/v1.0/413274/images/11?now=1257695648897")).headers((Multimap)ImmutableMultimap.builder().put((Object)"X-Auth-Token", (Object)authToken2).build()).build();
        HttpResponse imageDeleted = HttpResponse.builder().statusCode(204).message("HTTP/1.1 204 No Content").build();
        CloudServersClient clientWhenImageExists = (CloudServersClient)this.orderedRequestsSendResponses(initialAuth, responseWithUrls, deleteImage, pleaseRenew, initialAuth, responseWithUrls2, deleteImage2, imageDeleted);
        assert (clientWhenImageExists.deleteImage(11));
    }

    @Test(expectedExceptions={AuthorizationException.class})
    public void testDoesNotReauthenticateOnFatal401() {
        String authToken = "d6245d35-22a0-47c0-9770-2c5097da25fc";
        HttpRequest initialAuth = HttpRequest.builder().method("GET").endpoint(URI.create("https://auth/v1.0")).headers((Multimap)ImmutableMultimap.builder().put((Object)"X-Auth-User", (Object)"identity").put((Object)"X-Auth-Key", (Object)"credential").put((Object)"Accept", (Object)"*/*").build()).build();
        HttpResponse responseWithUrls = HttpResponse.builder().statusCode(204).message("HTTP/1.1 204 No Content").headers((Multimap)ImmutableMultimap.builder().put((Object)"Server", (Object)"Apache/2.2.3 (Red Hat)").put((Object)"vary", (Object)"X-Auth-Token,X-Auth-Key,X-Storage-User,X-Storage-Pass").put((Object)"X-Storage-Url", (Object)"https://storage101.dfw1.clouddrive.com/v1/MossoCloudFS_dc1f419c-5059-4c87-a389-3f2e33a77b22").put((Object)"Cache-Control", (Object)"s-maxage=86399").put((Object)"Content-Type", (Object)"text/xml").put((Object)"Date", (Object)"Tue, 10 Jan 2012 22:08:47 GMT").put((Object)"X-Auth-Token", (Object)authToken).put((Object)"X-Server-Management-Url", (Object)"https://servers.api.rackspacecloud.com/v1.0/413274").put((Object)"X-Storage-Token", (Object)authToken).put((Object)"Connection", (Object)"Keep-Alive").put((Object)"X-CDN-Management-Url", (Object)"https://cdn1.clouddrive.com/v1/MossoCloudFS_dc1f419c-5059-4c87-a389-3f2e33a77b22").put((Object)"Content-Length", (Object)"0").build()).build();
        HttpRequest deleteImage = HttpRequest.builder().method("DELETE").endpoint(URI.create("https://servers.api.rackspacecloud.com/v1.0/413274/images/11?now=1257695648897")).headers((Multimap)ImmutableMultimap.builder().put((Object)"X-Auth-Token", (Object)authToken).build()).build();
        HttpResponse unauthResponse = HttpResponse.builder().statusCode(401).message("HTTP/1.1 401 Unauthorized").payload((Payload)Payloads.newStringPayload((String)"[{\"unauthorized\":{\"message\":\"Fatal unauthorized.\",\"code\":401}}]")).build();
        CloudServersClient client = (CloudServersClient)this.orderedRequestsSendResponses(initialAuth, responseWithUrls, deleteImage, unauthResponse);
        client.deleteImage(11);
    }

    @Test(enabled=false, expectedExceptions={AuthorizationException.class})
    public void testDoesNotReauthenticateOnAuthentication401() {
        HttpRequest initialAuth = HttpRequest.builder().method("GET").endpoint(URI.create("https://auth/v1.0")).headers((Multimap)ImmutableMultimap.builder().put((Object)"X-Auth-User", (Object)"identity").put((Object)"X-Auth-Key", (Object)"credential").put((Object)"Accept", (Object)"*/*").build()).build();
        HttpResponse unauthResponse = HttpResponse.builder().statusCode(401).message("HTTP/1.1 401 Unauthorized").payload((Payload)Payloads.newStringPayload((String)"[{\"unauthorized\":{\"message\":\"A different message implying fatal.\",\"code\":401}}]")).build();
        CloudServersClient client = (CloudServersClient)this.orderedRequestsSendResponses(initialAuth, unauthResponse);
        client.deleteImage(11);
    }
}

