/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudservers.options;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.net.URI;
import java.util.HashMap;
import org.jclouds.cloudservers.options.RebuildServerOptions;
import org.jclouds.http.HttpRequest;
import org.jclouds.json.config.GsonModule;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class RebuildServerOptionsTest {
    Injector injector = Guice.createInjector((Module[])new Module[]{new GsonModule()});

    @Test
    public void testAddPayloadToRequestMapOfStringStringHttpRequest() {
        RebuildServerOptions options = new RebuildServerOptions();
        HttpRequest request = this.buildRequest(options);
        Assert.assertEquals((Object)"{\"rebuild\":{}}", (Object)request.getPayload().getRawContent());
    }

    private HttpRequest buildRequest(RebuildServerOptions options) {
        this.injector.injectMembers((Object)options);
        HttpRequest request = new HttpRequest("POST", URI.create("http://localhost"));
        options.bindToRequest(request, new HashMap());
        return request;
    }

    @Test
    public void testWithServer() {
        RebuildServerOptions options = new RebuildServerOptions();
        options.withImage(3);
        HttpRequest request = this.buildRequest(options);
        this.assertRebuild(request);
    }

    @Test
    public void testWithServerStatic() {
        RebuildServerOptions options = RebuildServerOptions.Builder.withImage((int)3);
        HttpRequest request = this.buildRequest(options);
        this.assertRebuild(request);
    }

    private void assertRebuild(HttpRequest request) {
        Assert.assertEquals((Object)"{\"rebuild\":{\"imageId\":3}}", (Object)request.getPayload().getRawContent());
    }
}

