/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudservers.functions;

import com.google.common.collect.ImmutableList;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import java.io.InputStream;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.List;
import org.jclouds.cloudservers.domain.Flavor;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.UnwrapOnlyJsonValue;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.json.config.GsonModule;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class ParseFlavorListFromJsonResponseTest {
    Injector i = Guice.createInjector((Module[])new Module[]{new GsonModule()});

    public void testApplyInputStream() {
        InputStream is = this.getClass().getResourceAsStream("/test_list_flavors.json");
        ImmutableList expects = ImmutableList.of((Object)new Flavor(1, "256 MB Server"), (Object)new Flavor(2, "512 MB Server"));
        UnwrapOnlyJsonValue parser = (UnwrapOnlyJsonValue)this.i.getInstance(Key.get((TypeLiteral)new TypeLiteral<UnwrapOnlyJsonValue<List<Flavor>>>(){}));
        List response = (List)parser.apply(new HttpResponse(200, "ok", (Payload)Payloads.newInputStreamPayload((InputStream)is)));
        Assert.assertEquals((Collection)response, (Collection)expects);
    }

    public void testApplyInputStreamDetails() throws UnknownHostException {
        InputStream is = this.getClass().getResourceAsStream("/test_list_flavors_detail.json");
        UnwrapOnlyJsonValue parser = (UnwrapOnlyJsonValue)this.i.getInstance(Key.get((TypeLiteral)new TypeLiteral<UnwrapOnlyJsonValue<List<Flavor>>>(){}));
        List response = (List)parser.apply(new HttpResponse(200, "ok", (Payload)Payloads.newInputStreamPayload((InputStream)is)));
        Assert.assertEquals((int)((Flavor)response.get(0)).getId(), (int)1);
        Assert.assertEquals((String)((Flavor)response.get(0)).getName(), (String)"256 MB Server");
        Assert.assertEquals((Object)((Flavor)response.get(0)).getDisk(), (Object)new Integer(10));
        Assert.assertEquals((Object)((Flavor)response.get(0)).getRam(), (Object)new Integer(256));
        Assert.assertEquals((int)((Flavor)response.get(1)).getId(), (int)2);
        Assert.assertEquals((String)((Flavor)response.get(1)).getName(), (String)"512 MB Server");
        Assert.assertEquals((Object)((Flavor)response.get(1)).getDisk(), (Object)new Integer(20));
        Assert.assertEquals((Object)((Flavor)response.get(1)).getRam(), (Object)new Integer(512));
    }
}

