/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudservers.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.cloudservers.domain.Server;
import org.jclouds.cloudservers.domain.ServerStatus;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.domain.NodeState;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationBuilder;
import org.jclouds.domain.LocationScope;
import org.jclouds.logging.Logger;

@Singleton
public class ServerToNodeMetadata
implements Function<Server, NodeMetadata> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    protected final Supplier<Location> location;
    protected final Map<String, Credentials> credentialStore;
    protected final Map<ServerStatus, NodeState> serverToNodeState;
    protected final Supplier<Set<? extends Image>> images;
    protected final Supplier<Set<? extends Hardware>> hardwares;

    @Inject
    ServerToNodeMetadata(Map<ServerStatus, NodeState> serverStateToNodeState, Map<String, Credentials> credentialStore, @Memoized Supplier<Set<? extends Image>> images, Supplier<Location> location, @Memoized Supplier<Set<? extends Hardware>> hardwares) {
        this.serverToNodeState = (Map)Preconditions.checkNotNull(serverStateToNodeState, (Object)"serverStateToNodeState");
        this.credentialStore = (Map)Preconditions.checkNotNull(credentialStore, (Object)"credentialStore");
        this.images = (Supplier)Preconditions.checkNotNull(images, (Object)"images");
        this.location = (Supplier)Preconditions.checkNotNull(location, (Object)"location");
        this.hardwares = (Supplier)Preconditions.checkNotNull(hardwares, (Object)"hardwares");
    }

    public NodeMetadata apply(Server from) {
        NodeMetadataBuilder builder = new NodeMetadataBuilder();
        builder.ids(from.getId() + "");
        builder.name(from.getName());
        builder.hostname(from.getName());
        builder.location(new LocationBuilder().scope(LocationScope.HOST).id(from.getHostId()).description(from.getHostId()).parent((Location)this.location.get()).build());
        builder.userMetadata(from.getMetadata());
        builder.group(ComputeServiceUtils.parseGroupFromName((String)from.getName()));
        builder.imageId(from.getImageId() + "");
        builder.operatingSystem(this.parseOperatingSystem(from));
        builder.hardware(this.parseHardware(from));
        builder.state(this.serverToNodeState.get((Object)from.getStatus()));
        builder.publicAddresses(from.getAddresses().getPublicAddresses());
        builder.privateAddresses(from.getAddresses().getPrivateAddresses());
        builder.credentials(this.credentialStore.get("node#" + from.getId()));
        return builder.build();
    }

    protected Hardware parseHardware(Server from) {
        try {
            return (Hardware)Iterables.find((Iterable)((Iterable)this.hardwares.get()), (Predicate)new FindHardwareForServer(from));
        }
        catch (NoSuchElementException e) {
            this.logger.warn("could not find a matching hardware for server %s", new Object[]{from});
            return null;
        }
    }

    protected OperatingSystem parseOperatingSystem(Server from) {
        try {
            return ((Image)Iterables.find((Iterable)((Iterable)this.images.get()), (Predicate)new FindImageForServer(from))).getOperatingSystem();
        }
        catch (NoSuchElementException e) {
            this.logger.warn("could not find a matching image for server %s in location %s", new Object[]{from, this.location});
            return null;
        }
    }

    private static class FindHardwareForServer
    implements Predicate<Hardware> {
        private final Server instance;

        private FindHardwareForServer(Server instance) {
            this.instance = instance;
        }

        public boolean apply(Hardware input) {
            return input.getProviderId().equals(this.instance.getFlavorId() + "");
        }
    }

    private static class FindImageForServer
    implements Predicate<Image> {
        private final Server instance;

        private FindImageForServer(Server instance) {
            this.instance = instance;
        }

        public boolean apply(Image input) {
            return input.getProviderId().equals(this.instance.getImageId() + "");
        }
    }
}

