/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudservers.compute.strategy;

import com.google.common.base.Function;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.cloudservers.CloudServersClient;
import org.jclouds.cloudservers.domain.Server;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.strategy.GetNodeMetadataStrategy;

@Singleton
public class CloudServersGetNodeMetadataStrategy
implements GetNodeMetadataStrategy {
    private final CloudServersClient client;
    private final Function<Server, NodeMetadata> serverToNodeMetadata;

    @Inject
    protected CloudServersGetNodeMetadataStrategy(CloudServersClient client, Function<Server, NodeMetadata> serverToNodeMetadata) {
        this.client = client;
        this.serverToNodeMetadata = serverToNodeMetadata;
    }

    public NodeMetadata getNode(String id) {
        int serverId = Integer.parseInt(id);
        Server server = this.client.getServer(serverId);
        return server == null ? null : (NodeMetadata)this.serverToNodeMetadata.apply((Object)server);
    }
}

