/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudservers.compute.functions;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.net.UnknownHostException;
import java.util.Map;
import org.jclouds.cloudservers.compute.config.CloudServersComputeServiceDependenciesModule;
import org.jclouds.cloudservers.compute.functions.CloudServersImageToImageTest;
import org.jclouds.cloudservers.compute.functions.FlavorToHardwareTest;
import org.jclouds.cloudservers.compute.functions.ServerToNodeMetadata;
import org.jclouds.cloudservers.domain.Server;
import org.jclouds.cloudservers.functions.ParseServerFromJsonResponseTest;
import org.jclouds.compute.domain.HardwareBuilder;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.domain.NodeState;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.domain.Processor;
import org.jclouds.compute.domain.Volume;
import org.jclouds.compute.domain.VolumeBuilder;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationBuilder;
import org.jclouds.domain.LocationScope;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class ServerToNodeMetadataTest {
    Location provider = new LocationBuilder().scope(LocationScope.ZONE).id("dallas").description("description").build();

    @Test
    public void testApplyWhereImageAndHardwareNotFoundButCredentialsFound() throws UnknownHostException {
        Credentials creds = new Credentials("root", "abdce");
        Map serverStateToNodeState = CloudServersComputeServiceDependenciesModule.serverToNodeState;
        ImmutableSet images = ImmutableSet.of();
        ImmutableSet hardwares = ImmutableSet.of();
        Server server = ParseServerFromJsonResponseTest.parseServer();
        ServerToNodeMetadata parser = new ServerToNodeMetadata(serverStateToNodeState, (Map)ImmutableMap.of((Object)"node#1234", (Object)creds), Suppliers.ofInstance((Object)images), Suppliers.ofInstance((Object)this.provider), Suppliers.ofInstance((Object)hardwares));
        NodeMetadata metadata = parser.apply(server);
        Assert.assertEquals((Object)metadata, (Object)new NodeMetadataBuilder().state(NodeState.PENDING).publicAddresses((Iterable)ImmutableSet.of((Object)"67.23.10.132", (Object)"67.23.10.131")).privateAddresses((Iterable)ImmutableSet.of((Object)"10.176.42.16")).imageId("2").id("1234").providerId("1234").name("sample-server").hostname("sample-server").credentials(creds).location(new LocationBuilder().scope(LocationScope.HOST).id("e4d909c290d0fb1ca068ffaddf22cbd0").description("e4d909c290d0fb1ca068ffaddf22cbd0").parent(this.provider).build()).userMetadata((Map)ImmutableMap.of((Object)"Server Label", (Object)"Web Head 1", (Object)"Image Version", (Object)"2.1")).build());
    }

    @Test
    public void testApplyWhereImageAndHardwareNotFound() throws UnknownHostException {
        Map serverStateToNodeState = CloudServersComputeServiceDependenciesModule.serverToNodeState;
        ImmutableSet images = ImmutableSet.of();
        ImmutableSet hardwares = ImmutableSet.of();
        Server server = ParseServerFromJsonResponseTest.parseServer();
        ServerToNodeMetadata parser = new ServerToNodeMetadata(serverStateToNodeState, (Map)ImmutableMap.of(), Suppliers.ofInstance((Object)images), Suppliers.ofInstance((Object)this.provider), Suppliers.ofInstance((Object)hardwares));
        NodeMetadata metadata = parser.apply(server);
        Assert.assertEquals((Object)metadata, (Object)new NodeMetadataBuilder().state(NodeState.PENDING).publicAddresses((Iterable)ImmutableSet.of((Object)"67.23.10.132", (Object)"67.23.10.131")).privateAddresses((Iterable)ImmutableSet.of((Object)"10.176.42.16")).imageId("2").id("1234").providerId("1234").name("sample-server").hostname("sample-server").location(new LocationBuilder().scope(LocationScope.HOST).id("e4d909c290d0fb1ca068ffaddf22cbd0").description("e4d909c290d0fb1ca068ffaddf22cbd0").parent(this.provider).build()).userMetadata((Map)ImmutableMap.of((Object)"Server Label", (Object)"Web Head 1", (Object)"Image Version", (Object)"2.1")).build());
    }

    @Test
    public void testApplyWhereImageFoundAndHardwareNotFound() throws UnknownHostException {
        Map serverStateToNodeState = CloudServersComputeServiceDependenciesModule.serverToNodeState;
        Image jcImage = CloudServersImageToImageTest.convertImage();
        ImmutableSet images = ImmutableSet.of((Object)jcImage);
        ImmutableSet hardwares = ImmutableSet.of();
        Server server = ParseServerFromJsonResponseTest.parseServer();
        ServerToNodeMetadata parser = new ServerToNodeMetadata(serverStateToNodeState, (Map)ImmutableMap.of(), Suppliers.ofInstance((Object)images), Suppliers.ofInstance((Object)this.provider), Suppliers.ofInstance((Object)hardwares));
        NodeMetadata metadata = parser.apply(server);
        Assert.assertEquals((Object)metadata, (Object)new NodeMetadataBuilder().state(NodeState.PENDING).publicAddresses((Iterable)ImmutableSet.of((Object)"67.23.10.132", (Object)"67.23.10.131")).privateAddresses((Iterable)ImmutableSet.of((Object)"10.176.42.16")).imageId("2").operatingSystem(new OperatingSystem.Builder().family(OsFamily.CENTOS).description("CentOS 5.2").version("5.2").is64Bit(true).build()).id("1234").providerId("1234").name("sample-server").hostname("sample-server").location(new LocationBuilder().scope(LocationScope.HOST).id("e4d909c290d0fb1ca068ffaddf22cbd0").description("e4d909c290d0fb1ca068ffaddf22cbd0").parent(this.provider).build()).userMetadata((Map)ImmutableMap.of((Object)"Server Label", (Object)"Web Head 1", (Object)"Image Version", (Object)"2.1")).build());
    }

    @Test
    public void testApplyWhereImageAndHardwareFound() throws UnknownHostException {
        Map serverStateToNodeState = CloudServersComputeServiceDependenciesModule.serverToNodeState;
        ImmutableSet images = ImmutableSet.of((Object)CloudServersImageToImageTest.convertImage());
        ImmutableSet hardwares = ImmutableSet.of((Object)FlavorToHardwareTest.convertFlavor());
        Server server = ParseServerFromJsonResponseTest.parseServer();
        ServerToNodeMetadata parser = new ServerToNodeMetadata(serverStateToNodeState, (Map)ImmutableMap.of(), Suppliers.ofInstance((Object)images), Suppliers.ofInstance((Object)this.provider), Suppliers.ofInstance((Object)hardwares));
        NodeMetadata metadata = parser.apply(server);
        Assert.assertEquals((Object)metadata, (Object)new NodeMetadataBuilder().state(NodeState.PENDING).publicAddresses((Iterable)ImmutableSet.of((Object)"67.23.10.132", (Object)"67.23.10.131")).privateAddresses((Iterable)ImmutableSet.of((Object)"10.176.42.16")).imageId("2").hardware(new HardwareBuilder().ids("1").name("256 MB Server").processors((Iterable)ImmutableList.of((Object)new Processor(1.0, 1.0))).ram(256).volumes((Iterable)ImmutableList.of((Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(10.0f)).durable(true).bootDevice(true).build())).build()).operatingSystem(new OperatingSystem.Builder().family(OsFamily.CENTOS).description("CentOS 5.2").version("5.2").is64Bit(true).build()).id("1234").providerId("1234").name("sample-server").hostname("sample-server").location(new LocationBuilder().scope(LocationScope.HOST).id("e4d909c290d0fb1ca068ffaddf22cbd0").description("e4d909c290d0fb1ca068ffaddf22cbd0").parent(this.provider).build()).userMetadata((Map)ImmutableMap.of((Object)"Server Label", (Object)"Web Head 1", (Object)"Image Version", (Object)"2.1")).build());
    }
}

