/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudservers.compute;

import com.google.inject.Module;
import java.io.IOException;
import org.jclouds.compute.BaseComputeServiceLiveTest;
import org.jclouds.compute.ComputeServiceContextFactory;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.domain.LocationScope;
import org.jclouds.rest.RestContext;
import org.jclouds.sshj.config.SshjSshClientModule;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, enabled=true, sequential=true)
public class CloudServersComputeServiceLiveTest
extends BaseComputeServiceLiveTest {
    public CloudServersComputeServiceLiveTest() {
        this.provider = "cloudservers";
    }

    protected Module getSshModule() {
        return new SshjSshClientModule();
    }

    public void testAssignability() throws Exception {
        RestContext tmContext = new ComputeServiceContextFactory().createContext(this.provider, this.identity, this.credential).getProviderSpecificContext();
    }

    protected void checkNodes(Iterable<? extends NodeMetadata> nodes, String tag) throws IOException {
        super.checkNodes(nodes, tag);
        for (NodeMetadata nodeMetadata : nodes) {
            Assert.assertEquals((Object)nodeMetadata.getLocation().getScope(), (Object)LocationScope.HOST);
        }
    }

    @Test(enabled=true, dependsOnMethods={"testReboot"}, expectedExceptions={UnsupportedOperationException.class})
    public void testSuspendResume() throws Exception {
        super.testSuspendResume();
    }

    @Test(enabled=true, dependsOnMethods={"testSuspendResume"})
    public void testGetNodesWithDetails() throws Exception {
        super.testGetNodesWithDetails();
    }

    @Test(enabled=true, dependsOnMethods={"testSuspendResume"})
    public void testListNodes() throws Exception {
        super.testListNodes();
    }

    @Test(enabled=true, dependsOnMethods={"testListNodes", "testGetNodesWithDetails"})
    public void testDestroyNodes() {
        super.testDestroyNodes();
    }
}

