/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudservers.compute.suppliers;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.cloudservers.CloudServersClient;
import org.jclouds.cloudservers.domain.Image;
import org.jclouds.cloudservers.options.ListOptions;
import org.jclouds.logging.Logger;

@Singleton
public class CloudServersImageSupplier
implements Supplier<Set<? extends org.jclouds.compute.domain.Image>> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    protected final CloudServersClient sync;
    protected final Function<Image, org.jclouds.compute.domain.Image> cloudServersImageToImage;

    @Inject
    CloudServersImageSupplier(CloudServersClient sync, Function<Image, org.jclouds.compute.domain.Image> cloudServersImageToImage) {
        this.sync = sync;
        this.cloudServersImageToImage = cloudServersImageToImage;
    }

    public Set<? extends org.jclouds.compute.domain.Image> get() {
        this.logger.debug(">> providing images", new Object[0]);
        LinkedHashSet images = Sets.newLinkedHashSet((Iterable)Iterables.transform(this.sync.listImages(ListOptions.Builder.withDetails()), this.cloudServersImageToImage));
        this.logger.debug("<< images(%d)", new Object[]{images.size()});
        return images;
    }
}

