/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudservers.functions;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import java.io.InputStream;
import java.net.UnknownHostException;
import org.jclouds.cloudservers.domain.BackupSchedule;
import org.jclouds.cloudservers.domain.DailyBackup;
import org.jclouds.cloudservers.domain.WeeklyBackup;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.UnwrapOnlyJsonValue;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.json.config.GsonModule;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class ParseBackupScheduleFromJsonResponseTest {
    Injector i = Guice.createInjector((Module[])new Module[]{new GsonModule()});

    public void testApplyInputStreamDetails() throws UnknownHostException {
        InputStream is = this.getClass().getResourceAsStream("/test_list_backupschedule.json");
        UnwrapOnlyJsonValue parser = (UnwrapOnlyJsonValue)this.i.getInstance(Key.get((TypeLiteral)new TypeLiteral<UnwrapOnlyJsonValue<BackupSchedule>>(){}));
        BackupSchedule response = (BackupSchedule)parser.apply(new HttpResponse(200, "ok", (Payload)Payloads.newInputStreamPayload((InputStream)is)));
        Assert.assertEquals((Object)new BackupSchedule(WeeklyBackup.THURSDAY, DailyBackup.H_0400_0600, true), (Object)response);
    }

    public void testNoSchedule() throws UnknownHostException {
        UnwrapOnlyJsonValue parser = (UnwrapOnlyJsonValue)this.i.getInstance(Key.get((TypeLiteral)new TypeLiteral<UnwrapOnlyJsonValue<BackupSchedule>>(){}));
        BackupSchedule response = (BackupSchedule)parser.apply(new HttpResponse(200, "ok", (Payload)Payloads.newStringPayload((String)"{\"backupSchedule\":{\"enabled\" : false}}")));
        Assert.assertEquals((Object)new BackupSchedule(), (Object)response);
    }
}

