/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudservers.compute.functions;

import com.google.common.base.Function;
import com.google.inject.Guice;
import com.google.inject.Module;
import java.net.UnknownHostException;
import org.jclouds.cloudservers.compute.functions.CloudServersImageToImage;
import org.jclouds.cloudservers.compute.functions.CloudServersImageToOperatingSystem;
import org.jclouds.cloudservers.domain.Image;
import org.jclouds.cloudservers.functions.ParseImageFromJsonResponseTest;
import org.jclouds.compute.config.BaseComputeServiceContextModule;
import org.jclouds.compute.domain.ImageBuilder;
import org.jclouds.compute.domain.OperatingSystemBuilder;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.reference.ComputeServiceConstants;
import org.jclouds.domain.Credentials;
import org.jclouds.json.Json;
import org.jclouds.json.config.GsonModule;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class CloudServersImageToImageTest {
    @Test
    public void testApplyWhereImageNotFound() throws UnknownHostException {
        Assert.assertEquals((Object)CloudServersImageToImageTest.convertImage(), (Object)new ImageBuilder().name("CentOS 5.2").operatingSystem(new OperatingSystemBuilder().family(OsFamily.CENTOS).version("5.2").description("CentOS 5.2").is64Bit(true).build()).description("CentOS 5.2").defaultCredentials(new Credentials("root", null)).ids("2").version("1286712000000").build());
    }

    public static org.jclouds.compute.domain.Image convertImage() {
        Image image = ParseImageFromJsonResponseTest.parseImage();
        CloudServersImageToImage parser = new CloudServersImageToImage((Function)new CloudServersImageToOperatingSystem(new BaseComputeServiceContextModule(){}.provideOsVersionMap(new ComputeServiceConstants.ReferenceData(), (Json)Guice.createInjector((Module[])new Module[]{new GsonModule()}).getInstance(Json.class))));
        return parser.apply(image);
    }
}

