/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudservers.binders;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.File;
import java.net.URI;
import java.util.Map;
import org.jclouds.cloudservers.binders.BindCreateImageToJsonPayload;
import org.jclouds.http.HttpRequest;
import org.jclouds.json.config.GsonModule;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class BindCreateImageToJsonPayloadTest {
    Injector injector = Guice.createInjector((Module[])new Module[]{new GsonModule()});

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testMustBeMap() {
        BindCreateImageToJsonPayload binder = new BindCreateImageToJsonPayload();
        this.injector.injectMembers((Object)binder);
        HttpRequest request = new HttpRequest("POST", URI.create("http://localhost"));
        binder.bindToRequest(request, (Object)new File("foo"));
    }

    @Test
    public void testCorrect() {
        BindCreateImageToJsonPayload binder = new BindCreateImageToJsonPayload();
        this.injector.injectMembers((Object)binder);
        HttpRequest request = new HttpRequest("PUT", URI.create("http://localhost"));
        binder.bindToRequest(request, (Map)ImmutableMap.of((Object)"imageName", (Object)"foo", (Object)"serverId", (Object)"2"));
        Assert.assertEquals((Object)"{\"image\":{\"serverId\":2,\"name\":\"foo\"}}", (Object)request.getPayload().getRawContent());
    }

    @Test(expectedExceptions={NullPointerException.class, IllegalStateException.class})
    public void testNullIsBad() {
        BindCreateImageToJsonPayload binder = new BindCreateImageToJsonPayload();
        this.injector.injectMembers((Object)binder);
        HttpRequest request = new HttpRequest("PUT", URI.create("http://localhost"));
        binder.bindToRequest(request, null);
    }
}

