/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudservers.binders;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.File;
import java.net.URI;
import java.util.Map;
import org.jclouds.cloudservers.binders.BindServerNameToJsonPayload;
import org.jclouds.http.HttpRequest;
import org.jclouds.json.config.GsonModule;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class BindServerNameToJsonPayloadTest {
    Injector injector = Guice.createInjector((Module[])new Module[]{new GsonModule()});

    @Test(expectedExceptions={IllegalStateException.class})
    public void testPostIsIncorrect() {
        BindServerNameToJsonPayload binder = new BindServerNameToJsonPayload();
        this.injector.injectMembers((Object)binder);
        HttpRequest request = new HttpRequest("POST", URI.create("http://localhost"));
        binder.bindToRequest(request, (Map)ImmutableMap.of((Object)"name", (Object)"foo"));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testMustBeString() {
        BindServerNameToJsonPayload binder = new BindServerNameToJsonPayload();
        this.injector.injectMembers((Object)binder);
        HttpRequest request = new HttpRequest("POST", URI.create("http://localhost"));
        binder.bindToRequest(request, (Object)new File("foo"));
    }

    @Test
    public void testCorrect() {
        BindServerNameToJsonPayload binder = new BindServerNameToJsonPayload();
        this.injector.injectMembers((Object)binder);
        HttpRequest request = new HttpRequest("PUT", URI.create("http://localhost"));
        binder.bindToRequest(request, (Object)"foo");
        Assert.assertEquals((Object)"{\"server\":{\"name\":\"foo\"}}", (Object)request.getPayload().getRawContent());
    }

    @Test(expectedExceptions={NullPointerException.class, IllegalStateException.class})
    public void testNullIsBad() {
        BindServerNameToJsonPayload binder = new BindServerNameToJsonPayload();
        this.injector.injectMembers((Object)binder);
        HttpRequest request = new HttpRequest("PUT", URI.create("http://localhost"));
        binder.bindToRequest(request, null);
    }
}

