/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudservers.functions;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import java.io.InputStream;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jclouds.cloudservers.domain.Addresses;
import org.jclouds.cloudservers.domain.Server;
import org.jclouds.cloudservers.domain.ServerStatus;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.UnwrapOnlyJsonValue;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.json.config.GsonModule;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class ParseServerListFromJsonResponseTest {
    Injector i = Guice.createInjector((Module[])new Module[]{new GsonModule()});

    public void testApplyInputStream() {
        InputStream is = this.getClass().getResourceAsStream("/test_list_servers.json");
        ImmutableList expects = ImmutableList.of((Object)new Server(1234, "sample-server"), (Object)new Server(5678, "sample-server2"));
        UnwrapOnlyJsonValue parser = (UnwrapOnlyJsonValue)this.i.getInstance(Key.get((TypeLiteral)new TypeLiteral<UnwrapOnlyJsonValue<List<Server>>>(){}));
        List response = (List)parser.apply(new HttpResponse(200, "ok", (Payload)Payloads.newInputStreamPayload((InputStream)is)));
        Assert.assertEquals((Collection)response, (Collection)expects);
    }

    public void testApplyInputStreamDetails() throws UnknownHostException {
        InputStream is = this.getClass().getResourceAsStream("/test_list_servers_detail.json");
        UnwrapOnlyJsonValue parser = (UnwrapOnlyJsonValue)this.i.getInstance(Key.get((TypeLiteral)new TypeLiteral<UnwrapOnlyJsonValue<List<Server>>>(){}));
        List response = (List)parser.apply(new HttpResponse(200, "ok", (Payload)Payloads.newInputStreamPayload((InputStream)is)));
        Assert.assertEquals((int)((Server)response.get(0)).getId(), (int)1234);
        Assert.assertEquals((String)((Server)response.get(0)).getName(), (String)"sample-server");
        Assert.assertEquals((Object)((Server)response.get(0)).getImageId(), (Object)new Integer(2));
        Assert.assertEquals((Object)((Server)response.get(0)).getFlavorId(), (Object)new Integer(1));
        Assert.assertEquals((String)((Server)response.get(0)).getHostId(), (String)"e4d909c290d0fb1ca068ffaddf22cbd0");
        Assert.assertEquals((Object)((Server)response.get(0)).getStatus(), (Object)ServerStatus.BUILD);
        Assert.assertEquals((Object)((Server)response.get(0)).getProgress(), (Object)new Integer(60));
        ArrayList publicAddresses = Lists.newArrayList((Object[])new String[]{"67.23.10.132", "67.23.10.131"});
        ArrayList privateAddresses = Lists.newArrayList((Object[])new String[]{"10.176.42.16"});
        Addresses addresses1 = new Addresses();
        addresses1.getPrivateAddresses().addAll(privateAddresses);
        addresses1.getPublicAddresses().addAll(publicAddresses);
        Assert.assertEquals((Object)((Server)response.get(0)).getAddresses(), (Object)addresses1);
        Assert.assertEquals((Object)((Server)response.get(0)).getMetadata(), (Object)ImmutableMap.of((Object)"Server Label", (Object)"Web Head 1", (Object)"Image Version", (Object)"2.1"));
        Assert.assertEquals((int)((Server)response.get(1)).getId(), (int)5678);
        Assert.assertEquals((String)((Server)response.get(1)).getName(), (String)"sample-server2");
        Assert.assertEquals((Object)((Server)response.get(1)).getImageId(), (Object)new Integer(2));
        Assert.assertEquals((Object)((Server)response.get(1)).getFlavorId(), (Object)new Integer(1));
        Assert.assertEquals((String)((Server)response.get(1)).getHostId(), (String)"9e107d9d372bb6826bd81d3542a419d6");
        Assert.assertEquals((Object)((Server)response.get(1)).getStatus(), (Object)ServerStatus.ACTIVE);
        Assert.assertEquals((Object)((Server)response.get(1)).getProgress(), null);
        ArrayList publicAddresses2 = Lists.newArrayList((Object[])new String[]{"67.23.10.133"});
        ArrayList privateAddresses2 = Lists.newArrayList((Object[])new String[]{"10.176.42.17"});
        Addresses addresses2 = new Addresses();
        addresses2.getPrivateAddresses().addAll(privateAddresses2);
        addresses2.getPublicAddresses().addAll(publicAddresses2);
        Assert.assertEquals((Object)((Server)response.get(1)).getAddresses(), (Object)addresses2);
        Assert.assertEquals((Object)((Server)response.get(1)).getMetadata(), (Object)ImmutableMap.of((Object)"Server Label", (Object)"DB 1"));
    }
}

